@extends('layouts.app')
@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Verify Two Factor Authentication </div>
                <div class="panel-body">
                    @if($user->is_two_factor_enabled)
                    <form class="form-horizontal" role="form" method="POST" action="{{ url('/disable-2fa') }}">
                    @else
                    <form class="form-horizontal" role="form" method="POST" action="{{ url('/enable-2fa') }}">
                    @endif
                        {{ csrf_field() }}
                        <div class="alert alert-warning">
                            Google Authenticator generates 2-Step Verification codes on your phone.
2-Step Verification provides stronger security for account by requiring a second step of verification when you sign in. In addition to your password, you’ll also need a code generated by the Google Authenticator app on your phone.
                        </div>
                        <div class="form-group text-center">
                        @if(! $user->is_two_factor_enabled)
                        <p>Please scan this barcode using <strong>Google Authenticator</strong> or <strong>Authy</strong> client Application and Click Enable Button</p>
                            <img src="{{ $barcode }}" />
                        @endif
                        </div>
                        <div class="form-group text-center">
                            <div class="col-md-8 col-md-offset-2">
                            @if($user->is_two_factor_enabled)
                                <button type="submit" class="btn btn-danger">
                                    Disable Two Factor Authentication
                                </button>
                            @else
                                <button type="submit" class="btn btn-success">
                                    Enable Two Factor Authentication
                                </button>
                            @endif
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection