<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item active">Sondages</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("pageTopMenu"); ?>
    <a class="btn" href="<?php echo e(route('newSurvey')); ?>">+ Ajouter sondage</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo csrf_field(); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des sondages
                    <div class="col-sm-4 pull-right">
                        <form class="form-horizontal" id="search_survey" action="<?php echo e(route('searchSurvey')); ?>" method="get">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group">
                                        <input class="form-control" type="text" value="<?php echo e($title?? ''); ?>" name="search_survey_title" placeholder="Titre" required>
                                        <span class="input-group-append">
                                            <button class="btn btn-primary" type="submit">
                                            <i class="fa fa-search"></i> Recherche</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card-body">


                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>Date</td>
                                <td>Titre</td>
                                <td>Date de debut</td>
                                <td>Date de fin</td>
                                <td>Activé</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $surveys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $survey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($survey->created_at->format("d/m/Y")); ?></td>
                                    <td><?php echo e($survey->name); ?></td>
                                    <td><?php echo e($survey->startDate); ?></td>
                                    <td><?php echo e($survey->endDate); ?></td>
                                    <td>
                                        <label class="switch switch-label switch-success">
                                        <input
                                            class="switch-input survey-switch-input"
                                            type="checkbox"
                                            <?php if($survey->status==1): ?> checked <?php endif; ?>
                                            data-id="<?php echo e($survey->id); ?>"
                                            data-desactivate-route="<?php echo e(route('surveyDesactivate')); ?>"
                                            data-activate-route="<?php echo e(route('surveyActivate')); ?>"
                                            data-token="<?php echo e(csrf_token()); ?>"
                                        >
                                            <span class="switch-slider" data-checked="On" data-unchecked="Off"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('editSurvey',['surveyId'=>$survey->id])); ?>" class="btn btn-sm btn-primary">Editer</a>
                                        <?php if((Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster") || Auth::user()->hasRole("JournalisteWeb")) || $survey->status!=1): ?>
                                            <a href="<?php echo e(route('deleteSurvey',['surveyId'=>$survey->id])); ?>" class="btn btn-sm btn-warning deleteSurvey">Supprimer</a>
                                        <?php endif; ?>
                                        <a href="http://localhost:8001/استطلاعات-الرأي/<?php echo e($survey->id); ?>" target="_blank" class="btn btn-sm btn-info">Preview</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>

                    <?php echo e($surveys->onEachSide(5)->links()); ?>

                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/scripts/surveys/list.js')); ?>"></script>
    <script src="<?php echo e(asset('js/scripts/surveys/delete-survey.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\diwan-backoff\resources\views/surveys/list-surveys.blade.php ENDPATH**/ ?>