<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item ">
    <a href="<?php echo e(route("menuMobile")); ?>">Menus (tags)</a>
</li>
<li class="breadcrumb-item active">
    Nouveau menu
</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="<?php echo e(route('ajxNewMenuMobileTags')); ?>" method="post" id="createTag">

                <?php echo csrf_field(); ?>


                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Nouveau menu
                    </div>

                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="title" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-5">
                                    <div class="form-group">
                                        <label class="form-col-form-label" for="tags">Tags</label>
                                        <select class="form-control" id='tags' name='tags[]'>
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                            </div>
                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/scripts/menusMobileTag/create.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('#tags').select2({
                tags: "true",
                ajax:{
                    url:"<?php echo e(route('tagsAjaxList')); ?>",
                    type:'get',
                    delay: 250,
                    data: function (params) {
                        var query = {
                            term: params.term
                        }
                        return query;
                    },
                    processResults: function (response){
                        return {
                            results:response
                        }
                    }
                },
                minimumInputLength:2
            });
            //$('#tagss').select2();


        });
        CKEDITOR.replace( 'content',CKoptions );
        for (var i in CKEDITOR.instances) {
            CKEDITOR.instances[i].on('change', function() { CKEDITOR.instances[i].updateElement() });
        }
    </script>
    <script>
        $(document).ready(function(){
            $("select.tags-predefinis").on("change",function(e){
                var optionText = $(this).children("option:selected").text();
                //var optionValue = $(this).children("option:selected").text();
                if ($('#tags').find("option[value='" + optionText + "']").length) {
                    aux=$('#tags').val();
                    aux.push(optionText);
                    $('#tags').val(aux).trigger('change');
                } else {
                    // Create a DOM Option and pre-select by default
                    var newOption = new Option(optionText, optionText, true, true);
                    // Append it to the select
                    //$('#tags').append('<option>NewOption</option>').trigger('change');
                    $('#tags').append(newOption).trigger('change');
                    //$("#tagss option:selected").attr('disabled','disabled');
                }
                //$('#tags').append(`<option value="${optionText}"> ${optionValue} </option>`);
            });
        });





    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>