<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item ">
    <a href="<?php echo e(route('programsList')); ?>">Liste des emissions</a>
</li>
<li class="breadcrumb-item active">
    Programmations (<?php echo e($program->title); ?>)
</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("pageTopMenu"); ?>
    <a class="btn" href="<?php echo e(route('newProgramming',['programId'=>$program->id])); ?>">+ Ajouter programmation</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo csrf_field(); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Programmation
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>Jour</td>
                                <td>Heure Début</td>
                                <td>Heure Fin</td>
                                <td>OnAir</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $programmings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $programming): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo trans('days.'.$programming->day); ?></td>
                                    <td><?php echo e($programming->start_time); ?></td>
                                    <td><?php echo e($programming->end_time); ?></td>
                                    <td>
                                        <?php if($programming->onair): ?> Oui <?php else: ?> Non <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('editProgramming',['programId'=>$program->id,'programmingId'=>$programming->id])); ?>" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="<?php echo e(route('deleteProgramming',['programId'=>$program->id,'programmingId'=>$programming->id])); ?>" class="btn btn-sm btn-warning deleteProgramming">Supprimer</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/scripts/programs/delete-programming.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\diwan-backoff\resources\views/programs/list-programming.blade.php ENDPATH**/ ?>