

<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item active">Galleries photos</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("pageTopMenu"); ?>
    <a class="btn" href="<?php echo e(route('newGallery')); ?>">+ Ajouter gallerie photos</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo csrf_field(); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des Galleries
                    <div class="col-sm-4 pull-right">
                        <form class="form-horizontal" id="search_post" action="<?php echo e(route('searchGallerie')); ?>" method="get">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group">
                                        <input class="form-control" type="text" value="<?php echo e($title?? ''); ?>" name="search_post_title" placeholder="Titre" required>
                                        <span class="input-group-append">
                                                <button class="btn btn-primary" type="submit">
                                                <i class="fa fa-search"></i> Recherche</button>
                                            </span>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>Date</td>
                                <td>Titre</td>
                                <td>Catégories</td>
                                <td>Tags</td>
                                <td>Auteur</td>
                                <td>Etat</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($article->created_at->format("d/m/Y")); ?></td>
                                    <td><?php echo e($article->title); ?></td>
                                    <td>
                                        <?php $__currentLoopData = $article->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge badge-success"><?php echo e($category->title); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td>
                                        <?php $__currentLoopData = $article->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge badge-success"><?php echo e($tag->title); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td><?php echo e($article->user->name); ?></td>
                                    <td>
                                        <?php if($article->status==0): ?>
                                            Brouillon
                                        <?php elseif($article->status==1): ?>
                                            En attente de publication
                                        <?php elseif($article->status==2): ?>
                                            Publié
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('editGallery',['galleryId'=>$article->id])); ?>" class="btn btn-sm btn-primary">Editer</a>
                                        <?php if((Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster") || Auth::user()->hasRole("JournalisteWeb")) || $article->status!=2): ?>
                                            <a href="<?php echo e(route('deleteGallery',['galleryId'=>$article->id])); ?>" class="btn btn-sm btn-warning deleteGallery">Supprimer</a>
                                        <?php endif; ?>
                                        <a href="http://www.diwanfm.net/news/preview/<?php echo e($article->categories->first()->url_rewrite); ?>/<?php echo e($article->url_rewrite); ?>" target="_blank" class="btn btn-sm btn-info">Preview</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>

                    <?php echo e($posts->onEachSide(5)->links()); ?>

                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/scripts/posts/delete-gallery.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>