

<?php $__env->startSection("breadcrumb"); ?>
    <li class="breadcrumb-item ">
        <a href="<?php echo e(route('marchiProductsList')); ?>">El marchi</a>
    </li>
    <li class="breadcrumb-item">
        <a href="<?php echo e(route('marchiDays')); ?>">
            Liste des jours
        </a>
    </li>
    <li class="breadcrumb-item active">
        Nouveau jour
    </li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <form action="<?php echo e(route('ajxNewMarchiDay')); ?>" method="post" id="createForm" >
                <?php echo csrf_field(); ?>

                <div class="card">

                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Nouveau jour
                    </div>


                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="day_date">Date *</label>
                                    <input class="form-control" type="text" name="day_date" id="day_date" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                        </div>

                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <h2><?php echo e($category->title); ?></h2>
                            <table class="table table-responsive-sm table-striped">
                                <thead>
                                    <th></th>
                                    <th>Produit</th>
                                    <th>Prix Min</th>
                                    <th>Prix Max</th>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $category->marchiProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <input type="checkbox" name="product_check_<?php echo e($product->id); ?>" id="product_check_<?php echo e($product->id); ?>" class="form-control" checked />
                                            </td>
                                            <td>
                                                <?php echo e($product->title); ?>

                                            </td>
                                            <td>
                                                <div clas="form-group">
                                                    <input type="text" name="product_min_price_<?php echo e($product->id); ?>" id="product_min_price_<?php echo e($product->id); ?>" class="form-control" />
                                                    <div class="invalid-feedback"></div>
                                                </div>
                                            </td>
                                            <td>
                                                <div clas="form-group">
                                                    <input type="text" name="product_max_price_<?php echo e($product->id); ?>" id="product_max_price_<?php echo e($product->id); ?>" class="form-control" />
                                                    <div class="invalid-feedback"></div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        $(document).ready(function(){
            $("#day_date").datetimepicker({
                format:"DD/MM/YYYY"
            });
        });
    </script>
    <script src="<?php echo e(asset('js/scripts/marchi/create-day.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>