

<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item active">Emissions</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("pageTopMenu"); ?>
    <a class="btn" href="<?php echo e(route('newProgram')); ?>">+ Ajouter Emission</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo csrf_field(); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des émissions
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Titre</td>
                                <td>Animateur</td>
                                <td>Status</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $programs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($program->id); ?></td>
                                    <td><?php echo e($program->title); ?></td>
                                    <td>
                                        <?php $__currentLoopData = $program->animators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $animator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge badge-primary"><?php echo e($animator->name); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td>
                                        <?php if($program->status==0): ?>
                                            Désactivé
                                        <?php elseif($program->status==1): ?>
                                            Publié
                                        <?php else: ?>
                                            Archive
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('editProgram',['programId'=>$program->id])); ?>" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="<?php echo e(route('deleteProgram',['programId'=>$program->id])); ?>" class="btn btn-sm btn-warning deleteProgram">Supprimer</a>
                                        <a href="<?php echo e(route('programSeances',['programId'=>$program->id])); ?>" class="btn btn-sm btn-info">Seances</a>
                                        <a href="<?php echo e(route('programming',['programId'=>$program->id])); ?>" class="btn btn-sm btn-success">Programmation</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>

                    <?php echo e($programs->onEachSide(5)->links()); ?>

                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/scripts/programs/delete.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>