<?php $__env->startSection("breadcrumb"); ?>
    <li class="breadcrumb-item active">
        Migrator
    </li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("pageTopMenu"); ?>
    <a class="btn" href="#" id="lanchMigration">Lancer la migration</a>
    <input type="hidden" id="csrf" value="<?php echo e(csrf_token()); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="card">

                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Liste des modules
                    </div>

                    <div class="card-body">
                        <table class="table table-responsive-sm table-striped">
                            <thead>
                            <tr>
                                <td>Module</td>
                                <td>Etat</td>
                                <td>Progression</td>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td>
                                    Marchi Categories
                                </td>
                                <td id="marchiCategoriesModuleState">
                                    En attente
                                </td>
                                <td id="marchiCategoriesModuleProgress">
                                    0%
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Marchi Products
                                </td>
                                <td id="marchiProductsModuleState">
                                    En attente
                                </td>
                                <td id="marchiProductsModuleProgress">
                                    0%
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Prix du jours des produits
                                </td>
                                <td id="marchiDayPricesModuleState">
                                    En attente
                                </td>
                                <td id="marchiDayPricesModuleProgress">
                                    0%
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

    <script>
        var categories = [];
        var products = [];
        var prices = [];

        //lanch function
        lanchMigration = function () {
            scriptState = 1;
            getCategories();
        }

        //getCategories function
        getCategories = function () {

            $("#marchiCategoriesModuleState").html("En cours");
            $.ajax({
                url: "<?php echo e(route('marchiCategoriesMigrator')); ?>",
                method: "get",
                dataType: "json",
                success: function (data) {
                    categories = data.categories;
                    $("#marchiCategoriesModuleState").html("Términé");
                    $("#marchiCategoriesModuleProgress").html("100%");
                    getMarchiProducts();
                }
            });
        }

        //get products
        getMarchiProducts = function () {
            $("#programsModuleState").html("Récupération des données");
            $.ajax({
                url: "<?php echo e(route('marchiGetProductsMigrator')); ?>",
                method: "get",
                dataType: "json",
                success: function (data) {
                    products = data.products;
                    debugger;
                    $("#marchiProductsModuleState").html("En cours");
                    var intRef = setInterval(function () {
                        notreadyfilter = products.filter(function (oneProduct) {
                            return (oneProduct.newID == undefined);
                        });
                        if (notreadyfilter.length == 0) {
                            clearInterval(intRef);
                            $("#marchiProductsModuleProgress").html("100%");
                            $("#marchiProductsModuleState").html("Terminé");
                            //continue
                            getMarchiPrices();

                        } else {
                            var pourcentage = 100 - Math.round((100 * notreadyfilter.length) / products.length);
                            $("#marchiProductsModuleProgress").html(pourcentage + "%");
                        }
                    }, 1000);
                    i = 0;
                    var saveRef = setInterval(function () {
                        saveMarchiProducts(i);
                        i++;
                        if (i == products.length) {
                            clearInterval(saveRef);
                        }
                    }, 300);
                }
            });
        }

        //save and return object with new ID
        saveMarchiProducts = function (index) {
            var prodCategory = categories.filter(function (prodCateg) {
                return (prodCateg.id == products[index].category);
            });
           // debugger;
            $.ajax({
                url: "<?php echo e(route('marchiSaveProductsMigrator')); ?>",
                method: "post",
                data: "record=" + JSON.stringify(products[index])+"&category="+ JSON.stringify(prodCategory[0].newID),
                dataType: "json",
                success: function (productsData) {
                    products[index] = productsData.product;
                },error: function (xhr, ajaxOptions, thrownError) {
                    console.log(xhr.status);
                    console.log(thrownError);
                }
            });
        }

        //get prices
        getMarchiPrices = function () {
            $("#marchiDayPricesModuleState").html("Récupération des données");
            $.ajax({
                url: "<?php echo e(route('marchiGetPricesMigrator')); ?>",
                method: "get",
                dataType: "json",
                success: function (data) {
                    prices = data.prices;
                   // debugger;
                    $("#marchiDayPricesModuleState").html("En cours");
                    var intRef = setInterval(function () {
                        notreadyfilter = prices.filter(function (onePrice) {
                            return (onePrice.newID == undefined);
                        });
                        if (notreadyfilter.length == 0) {
                            clearInterval(intRef);
                            $("#marchiDayPricesModuleProgress").html("100%");
                            $("#marchiDayPricesModuleState").html("Terminé");
                            //The end
                        } else {
                            var pourcentage = 100 - Math.round((100 * notreadyfilter.length) / prices.length);
                            $("#marchiDayPricesModuleProgress").html(pourcentage + "%");
                        }
                    }, 1000);
                    i = 0;
                    var saveRef = setInterval(function () {
                        saveMarchiPrices(i);
                        i++;
                        if (i == prices.length) {
                            clearInterval(saveRef);
                        }
                    }, 300);
                }
            });
        }

        saveMarchiPrices = function (index) {
            //get the product of current price
            var priceProduct = products.filter(function (priceProd) {
                return (priceProd.oldID == prices[index].product_id); //old_id
            });
            //debugger;
            if(priceProduct != undefined && priceProduct.length > 0){
                $.ajax({
                    url: "<?php echo e(route('marchiSavePricesMigrator')); ?>",
                    method: "post",
                    data: "record=" + JSON.stringify(prices[index]) + "&product=" + JSON.stringify(priceProduct[0].newID),
                    dataType: "json",
                    success: function (pricesData) {
                        prices[index] = pricesData.price;
                        console.log("price saved");
                    }, error: function (xhr, ajaxOptions, thrownError) {
                        console.log(xhr.status);
                        console.log(thrownError);
                    }
                });
            }else{
                prices[index].newID = -1;
                console.log("product not found with priceProductID:" + prices[index].product_id + " Day Date" + prices[index].day_date);
                debugger
            }
        }


        //lanch script
        $(document).ready(function () {
            $("#lanchMigration").on("click", function (e) {
                e.preventDefault();
                lanchMigration();
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>