<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item active">Videos</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("pageTopMenu"); ?>
    <a class="btn" href="<?php echo e(route('newVideo')); ?>">+ Ajouter video</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo csrf_field(); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des videos
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Titre</td>
                                <td>Catégories</td>
                                <td>Tags</td>
                                <td>Auteur</td>
                                <td>Etat</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($article->id); ?></td>
                                    <td><?php echo e($article->title); ?></td>
                                    <td>
                                        <?php $__currentLoopData = $article->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge badge-success"><?php echo e($category->title); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td>
                                        <?php $__currentLoopData = $article->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge badge-success"><?php echo e($tag->title); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td><?php echo e($article->user->name); ?></td>
                                    <td>
                                        <?php if($article->status==0): ?>
                                            Brouillon
                                        <?php elseif($article->status==1): ?>
                                            En attente de publication
                                        <?php elseif($article->status==2): ?>
                                            Publié
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('editVideo',['postId'=>$article->id])); ?>" class="btn btn-sm btn-primary">Editer</a>
                                        <?php if((Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster") || Auth::user()->hasRole("JournalisteWeb")) || $article->status!=2): ?>
                                            <a href="<?php echo e(route('deleteVideo',['videoId'=>$article->id])); ?>" class="btn btn-sm btn-warning deletePost">Supprimer</a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>

                    <?php echo e($posts->onEachSide(5)->links()); ?>

                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/scripts/posts/delete-video.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>