

<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item ">
    <a href="<?php echo e(route('kidsStoriesList')); ?>">Liste des videos</a>
</li>
<li class="breadcrumb-item active">
    Editer (<?php echo e($story->title); ?>)
</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="<?php echo e(route('ajxUpdateStory',['storyId'=>$story->id])); ?>" method="post" id="editForm" >

                <?php echo csrf_field(); ?>


                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer article
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="title" value="<?php echo e($story->title); ?>" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="category">Catégorie</label>
                                    <select class="form-control" id='category' name='category'>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>" <?php if($category->id == $story->category->id): ?> selected="selected" <?php endif; ?> ><?php echo e($category->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="summary">Résumé *</label>
                                    <textarea class="form-control" id="summary" name="summary"><?php echo e($story->summary); ?></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <input type="hidden" name="img" id="img" value="<?php echo e($story->photo); ?>" />
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_maker">Image *</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control imgSelector" value="<?php echo e($story->photo); ?>" data-photoMaker="<?php echo e(route('PhotoKids')); ?>" data-original="<?php echo e($story->photo); ?>" disabled name="img_maker" data-dest="img" id="img_maker" />
                                        <span class="input-group-append">
                                            <button class="btn btn-primary popup_selector" data-inputid="img_maker" type="button">
                                                <i class="fa fa-photo"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-warning popup_selector_colse" data-inputid="img_maker" type="button">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-success popup_selector_visualize" href="<?php echo e(config('paths.PHOTOS_URL').'kids/'.$story->photo); ?>" data-inputid="img_maker" type="button">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </span>
                                    </div>
                                    
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="youtube_url">Lien Youtube *</label>
                                    <input class="form-control" type="text" value="<?php echo e($story->youtube_url); ?>" name="youtube_url" id="youtube_url" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        var elfinderUrl='<?php echo e(url("/elfinder/popup")); ?>/';
        var storagePath='<?php echo e(config("paths.STORAGE_PATH")); ?>';
        var photosUrl='<?php echo e(config("paths.PHOTOS_URL")); ?>';
    </script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset( 'vendor/colorbox/css/colorbox.css')); ?>">
    <script src="<?php echo e(asset('vendor/colorbox/js/jquery.colorbox-min.js')); ?>"></script>
    <script src="<?php echo e(asset('packages/barryvdh/elfinder/js/standalonepopup.js')); ?>"></script>
    
    <script src="<?php echo e(asset('js/scripts/kids/edit-story.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>