<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item ">
    <a href="<?php echo e(route("menuMobileTags")); ?>">Menus (tags)</a>
</li>
<li class="breadcrumb-item active">
    Editer menu <?php echo e($menu->title); ?>

</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="<?php echo e(route('ajaxUpdateMenuMobileTags',['menuId'=>$menu->id])); ?>" method="post" id="editForm" >

                <?php echo csrf_field(); ?>


                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer menu
                    </div>

                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="title" value="<?php echo e($menu->title); ?>" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="tags">Tags</label>
                                    <select class="form-control" id='tags' name='tags[]'>
                                        <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($tag->id); ?>" <?php if($menu->tag_id===$tag->id): ?> selected="selected" <?php endif; ?>><?php echo e($tag->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/scripts/menusMobileTag/edit.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('#tags').select2({
                tags: "true",
                ajax:{
                    url:"<?php echo e(route('tagsAjaxList')); ?>",
                    type:'get',
                    delay: 250,
                    data: function (params) {
                        var query = {
                            term: params.term
                        }
                        return query;
                    },
                    processResults: function (response){
                        return {
                            results:response
                        }
                    }
                },
                minimumInputLength:2
            });
            //$('#tagss').select2();
        });
        CKEDITOR.replace( 'content',CKoptions );
        for (var i in CKEDITOR.instances) {
            CKEDITOR.instances[i].on('change', function() { CKEDITOR.instances[i].updateElement() });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>