<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item ">
        <a href="<?php echo e(route('listPodcasts')); ?>">Liste des podcasts</a>
    </li>
<li class="breadcrumb-item active">
    Editer Podcast (<?php echo e($podcast->title); ?>)
</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="<?php echo e(route('ajxUpdatePodcast',['podcastId'=>$podcast->id])); ?>" method="post" id="editForm" >

                <?php echo csrf_field(); ?>


                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer podcast
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="title" value="<?php echo e($podcast->title); ?>" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_title">Titre SEO *</label>
                                    <input class="form-control" type="text" value="<?php echo e($podcast->meta_title); ?>" name="meta_title" id="meta_title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_description">Déscription SEO *</label>
                                    <textarea class="form-control" id="meta_description" name="meta_description"><?php echo e($podcast->meta_description); ?></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="animator">Animateurs *</label>
                                    <select class="form-control" id='animator' name='animator[]' multiple="multiple">
                                        <?php $__currentLoopData = $animators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $animator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($animator->id); ?>" <?php if($podcast->animators->find($animator->id)): ?> selected="selected" <?php endif; ?> ><?php echo e($animator->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="seance">Emission *</label>
                                    <select class="form-control" id='seance' name='seance' >
                                        <option value=""></option>
                                        <?php $__currentLoopData = $programs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <optgroup label="<?php echo e($program->title); ?>">
                                                <?php $__currentLoopData = $program->programSeances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($seance->id); ?>" <?php if($podcast->programSeance->id==$seance->id): ?> selected="selected" <?php endif; ?>><?php echo e($seance->title); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </optgroup>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_keywords">Mots Clés *</label>
                                    <input class="form-control" type="text" value="<?php echo e($podcast->meta_keywords); ?>" name="meta_keywords" id="meta_keywords" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="live_date">Date live *</label>
                                    <input class="form-control" type="text" value="<?php echo e(Carbon\Carbon::CreateFromFormat('Y-m-d H:i:s',$podcast->live_date)->format('d/m/Y H:i:s')); ?>" name="live_date" id="live_date" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                
                                <div class="form-group">
                                    <label class="form-col-form-label" for="mp3_file_input">Fichier MP3 *</label>
                                    <div class="input-group">
                                        <input type="hidden" value="<?php echo e($podcast->mp3); ?>" name="mp3_file" id="mp3_file" />
                                        <input type="text" class="form-control imgSelector" value="<?php echo e($podcast->mp3); ?>" data-original="mp3_file" disabled name="mp3_file_input" id="mp3_file_input" />
                                        <span class="input-group-append">
                                            <button class="btn btn-primary popup_selector" data-inputid="mp3_file_input" type="button">
                                                <i class="fa fa-play"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-warning popup_selector_colse" data-inputid="mp3_file_input" type="button">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </span>
                                    </div>
                                    
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="status">Status</label>
                                    <select class="form-control" id='status' name='status'>
                                        <option value='0' <?php if($podcast->status==0): ?> selected="selected" <?php endif; ?> >Brouillon</option>
                                        <option value='1' <?php if($podcast->status==1): ?> selected="selected" <?php endif; ?> >Publié</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        var elfinderUrl='<?php echo e(url("/elfinder/popup")); ?>/';
        var storagePath='<?php echo e(config("paths.STORAGE_PATH")); ?>';
        var photosUrl='<?php echo e(config("paths.PHOTOS_URL")); ?>';
    </script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset( 'vendor/colorbox/css/colorbox.css')); ?>">
    <script src="<?php echo e(asset('vendor/colorbox/js/jquery.colorbox-min.js')); ?>"></script>
    <script src="<?php echo e(asset('packages/barryvdh/elfinder/js/standalonepopup.js')); ?>"></script>
    
    <script src="<?php echo e(asset('js/scripts/podcast/edit-podcast.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('#animator').select2();

            $("#live_date").datetimepicker({
                format:"DD/MM/YYYY HH:mm:ss"
            });
        });
        
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>