<?php
    $startDate = Carbon\Carbon::createFromFormat('Y-m-d', $survey->startDate)->format('d-m-Y');
    $endDate = Carbon\Carbon::createFromFormat('Y-m-d', $survey->endDate)->format('d-m-Y');
?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item ">
        <a href="<?php echo e(route('postsList')); ?>">Liste des sondages</a>
    </li>
    <li class="breadcrumb-item active">
        Editer sondage (<?php echo e($survey->name); ?>)
    </li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <form action="<?php echo e(route('ajxUpdateSurvey', ['surveyId' => $survey->id])); ?>" method="post" id="editForm">
                    <?php echo csrf_field(); ?>

                    <div class="card">
                        <div class="card-header">
                            <i class="fa fa-align-justify"></i>
                            Editer sondage
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-col-form-label" for="title">Titre</label>
                                        <input class="form-control" type="text" name="name" id="title"
                                            value="<?php echo e($survey->name); ?>" />
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-col-form-label" for="start_date">Date de début</label>
                                        <input class="form-control" type="text" value="<?php echo $startDate; ?>"
                                            id="startDate" name="startDate">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-col-form-label" for="end_date">Date de fin</label>
                                        <input class="form-control" type="text" value="<?php echo $endDate; ?>"
                                            id="endDate" name="endDate">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <div style="display: flex;align-items: baseline;justify-content: space-between;">
                                            <label class="form-col-form-label">Réponses sondage </label>
                                            <button style="margin-left: 1%;" class="btn btn-primary mt-3" type="button"
                                                id="addAnswer"><i class="icon fas fa-plus"> Ajouter une
                                                    ligne</i></button>
                                        </div>
                                        <div id="answersSurvey">
                                            <table class="table">
                                                <thead>
                                                    <tr>
                                                        <th style="text-align: center" class="col-md-10">Contenu</th>
                                                        <th style="text-align: center" class="col-md-2">Suppression</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $survey->answersSurveys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr data-answer-index="<?php echo e($key); ?>">
                                                            <td class="col-md-10"><input style="text-align: center"
                                                                    type="text" class="form-control"
                                                                    name="answers[<?php echo e($key); ?>]"
                                                                    value="<?php echo e($answer->name); ?>" /></td>
                                                            <td style="text-align: center" class="col-md-2">
                                                                <button type="button" class="btn btn-danger delete-answer"
                                                                    data-toggle="modal" data-target="#deleteModal"> <i
                                                                        class="fas fa-trash-alt"></i></button>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                            </div>
                        </div>
                </form>
                <!-- Modal -->
                <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Confirmation de suppression
                                </h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                Êtes-vous sûr de vouloir supprimer cette ligne ?
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                                <button type="button" class="btn btn-danger" id="confirmDelete">Supprimer</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/scripts/surveys/edit-survey.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        function reassignIndices() {
            $('#answersSurvey tbody tr').each(function(index) {
                $(this).find('input').attr('name', `answers[${index}]`);
            });
        }
        $('#answersSurvey').on('click', '.delete-answer', function() {
            const answerToDelete = $(this).closest('tr');
            $('#deleteModal').modal('show');
            $('#confirmDelete').click(function() {
                answerToDelete.remove();
                reassignIndices();
                $('#deleteModal').modal('hide');
            });
        });
        $('#addAnswer').click(function() {
            const newAnswer = `<tr>
            <td class="col-md-10"><input style="text-align: center" type="text" class="form-control" name="answers[${$('#answersSurvey tbody tr').length}]"/></td>
            <td style="text-align: center" class="col-md-2"><button type="button" class="btn btn-danger delete-answer" data-toggle="modal" data-target="#deleteModal"><i class="fas fa-trash-alt"></i></button></td>
        </tr>`;
            $('#answersSurvey tbody').append(newAnswer);
            reassignIndices();
        });
        // datepicker
        $("#startDate").datepicker({
            changeMonth: true,
            changeYear: true,
            showButtonPanel: true,
            dateFormat: 'dd-mm-yy',
        });
        $("#endDate").datepicker({
            changeMonth: true,
            changeYear: true,
            showButtonPanel: true,
            dateFormat: 'dd-mm-yy',
        });
    });
</script>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\diwan-backoff\resources\views/surveys/edit-survey.blade.php ENDPATH**/ ?>