<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item active">Contacts</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo csrf_field(); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des messages
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Nom & Prénom</td>
                                <td>Email</td>
                                <td>Sujet</td>
                                <td>Date</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr <?php if($contact->vue==false): ?> class="font-weight-bold" <?php endif; ?>>
                                    <td><?php echo e($contact->id); ?></td>
                                    <td><?php echo e($contact->name); ?></td>
                                    <td><?php echo e($contact->email); ?></td>
                                    <td><?php echo e($contact->subject); ?></td>
                                    <td><?php echo e($contact->created_at->format('d/m/Y')); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('contactShow',['contact'=>$contact->id])); ?>" class="btn btn-sm btn-info">Lire</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>