

<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item active">Utilisateurs</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des utilisateurs
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Nom & Prénom</td>
                                <td>Email</td>
                                <td>Roles</td>
                                <td>Activé</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($user->id); ?></td>
                                    <td><?php echo e($user->name); ?></td>
                                    <td><?php echo e($user->email); ?></td>
                                    <td>
                                        <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($role->name); ?> /
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td>
                                        <label class="switch switch-label switch-success">
                                        <input
                                            class="switch-input user-switch-input"
                                            type="checkbox"
                                            <?php if($user->status==1): ?> checked <?php endif; ?>
                                            data-id="<?php echo e($user->id); ?>"
                                            data-desactivate-route="<?php echo e(route('userDesactivate')); ?>"
                                            data-activate-route="<?php echo e(route('userActivate')); ?>"
                                            data-token="<?php echo e(csrf_token()); ?>"
                                        >
                                            <span class="switch-slider" data-checked="On" data-unchecked="Off"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('editUser',['userId'=>$user->id])); ?>" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="<?php echo e(route('editUserPassword',['userId'=>$user->id])); ?>" class="btn btn-sm btn-warning">Changer mot de passe</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/scripts/users/list.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>