<!DOCTYPE html>
<html lang="ar">
	<head>
		<base href="<?php echo e(url('/')); ?>" />
		<meta charset="utf-8">
    	<meta http-equiv="X-UA-Compatible" content="IE=edge">
    	<meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    	<title><?php echo e(config('app.name', 'Laravel')); ?></title>

    	<link href="<?php echo e(asset('template/css/coreui-icons.min.css')); ?>" rel="stylesheet">
    	<link href="<?php echo e(asset('template/css/font-awesome.min.css')); ?>" rel="stylesheet">
    	<link href="<?php echo e(asset('template/css/simple-line-icons.css')); ?>" rel="stylesheet">
    	<link href="<?php echo e(asset('template/plugins/jquery-ui/jquery-ui.min.css')); ?>" rel="stylesheet">
    	<link href="<?php echo e(asset('template/css/nestable.css')); ?>" rel="stylesheet">
    	<link href="<?php echo e(asset('template/css/select2.min.css')); ?>" rel="stylesheet">
    	<link href="<?php echo e(asset('template/css/bootstrap-datetimepicker.min.css')); ?>" rel="stylesheet">
    	<link href="<?php echo e(asset('template/css/pace.min.css')); ?>" rel="stylesheet">
    	<link href="<?php echo e(asset('template/css/style.css')); ?>" rel="stylesheet">
	</head>

	<body class="app header-fixed sidebar-fixed aside-menu-fixed sidebar-lg-show">

		<header class="app-header navbar">
			<button class="navbar-toggler sidebar-toggler d-lg-none mr-auto" type="button" data-toggle="sidebar-show">
		    	<span class="navbar-toggler-icon"></span>
		    </button>
		    <a class="navbar-brand" href="#">
		    	<img class="navbar-brand-full" src="<?php echo e(asset('template/img/logo.png')); ?>" width="89" height="25" alt="CoreUI Logo">
		    	<img class="navbar-brand-minimized" src="img/brand/sygnet.svg" width="30" height="30" alt="CoreUI Logo">
		    </a>
		    <button class="navbar-toggler sidebar-toggler d-md-down-none" type="button" data-toggle="sidebar-lg-show">
		    	<span class="navbar-toggler-icon"></span>
		    </button>

		    <ul class="nav navbar-nav d-md-down-none">
		    	<li class="nav-item px-3">
		    		<a class="nav-link" href="<?php echo e(route('home')); ?>">Acceuil</a>
				</li>
				<?php if(Auth::user()->hasRole("Admin")): ?>
					<li class="nav-item px-3">
						<a class="nav-link" href="<?php echo e(route('config')); ?>">Configuration</a>
					</li>
				<?php endif; ?>

		    </ul>

		    <ul class="nav navbar-nav ml-auto">

		    	<!--<li class="nav-item d-md-down-none">
		    		<a class="nav-link" href="#" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
		    			<i class="icon-bell"></i>
		    			<span class="badge badge-pill badge-danger">5</span>
		    		</a>
		    		<div class="dropdown-menu dropdown-menu-right dropdown-menu-lg">
		    			<div class="dropdown-header text-center">
		    				<strong>You have 5 notifications</strong>
		    			</div>
		    			<a class="dropdown-item" href="#">
		    				<i class="icon-user-follow text-success"></i> New user registered
		    			</a>
		    			<a class="dropdown-item" href="#">
		    				<i class="icon-user-follow text-success"></i> New user registered
		    			</a>
		    			<a class="dropdown-item" href="#">
		    				<i class="icon-user-follow text-success"></i> New user registered
		    			</a>
		    			<a class="dropdown-item" href="#">
		    				<i class="icon-user-follow text-success"></i> New user registered
		    			</a>
		    		</div>
		    	</li>-->

		    	<li class="nav-item dropdown">
		    		<a class="nav-link nav-link" data-toggle="dropdown" href="#" role="button" aria-haspopup="true" aria-expanded="false">
            			<img class="img-avatar" src="<?php echo e(asset('template/img/avatar.png')); ?>" alt="<?php echo e(Auth::user()->email); ?>">
          			</a>
          			<div class="dropdown-menu dropdown-menu-right">
          				<div class="dropdown-header text-center">
          					<?php $userCtrl = app('App\Http\Controllers\UserController'); ?>
          					<strong><?php echo e(Auth::user()->name); ?></strong>
          				</div>
          				<!--<a class="dropdown-item" href="#">
          					<i class="fa fa-envelope-o"></i> Messages
          					<span class="badge badge-success">42</span>
          				</a>
          				<a class="dropdown-item" href="#">
          					<i class="fa fa-user"></i> Profile
          				</a>-->
          				<a class="dropdown-item" href="<?php echo e(url('/logout')); ?>">
                    		<i class="fa fa-lock"></i> Logout
                    	</a>
                    </div>
		    	</li>

		    </ul>

		</header>

		<div class="app-body">

			<div class="sidebar">
				<nav class="sidebar-nav">
					<ul class="nav">
						<li class="nav-item">
							<a class="nav-link" href="<?php echo e(route('home')); ?>">
								<i class="nav-icon icon-speedometer"></i> Tableau de bord
							</a>
						</li>

						<?php if(Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster")): ?>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon fa fa-file-o"></i> Page
								</a>
								<ul class="nav-dropdown-items">
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('pagesList')); ?>">
											Liste des pages
										</a>
									</li>
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('newPage')); ?>">
											Nouvelle page
										</a>
									</li>
								</ul>
							</li>
						<?php endif; ?>

						<?php if(Auth::user()->hasRole("Admin")): ?>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon fa fa-user"></i> Utilisateurs
								</a>
								<ul class="nav-dropdown-items">
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('usersList')); ?>">
											Liste des utlisateurs
										</a>
									</li>
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('newUser')); ?>">
											Nouvel utilisateur
										</a>
									</li>
								</ul>
							</li>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon fa fa-user"></i> Internautes
								</a>
								<ul class="nav-dropdown-items">
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('socialUsersList')); ?>">
											Liste des internautes
										</a>
									</li>
									<!-- <li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('newUser')); ?>">
											Nouvel utilisateur
										</a>
									</li> -->
								</ul>
							</li>
						<?php endif; ?>

						<?php if(Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster") || Auth::user()->hasRole("MenuSecondaire")): ?>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon fa fa-bars"></i> Menus
								</a>
								<ul class="nav-dropdown-items">
									<li class="nav-item">
										<?php if(Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster")): ?>
											<a class="nav-link" href="<?php echo e(route('menus',['tag'=>'principal'])); ?>">
												Menu Principal
											</a>
										<?php endif; ?>
										<a class="nav-link" href="<?php echo e(route('menus',['tag'=>'secondaire'])); ?>">
											Menu Secondaire
										</a>
										<?php if(Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster")): ?>
											<a class="nav-link" href="<?php echo e(route('menus',['tag'=>'footer'])); ?>">
												Menu Footer
											</a>
											<a class="nav-link" href="<?php echo e(route('menus',['tag'=>'hamberger1'])); ?>">
												menu Hamberger 1
											</a>
											<a class="nav-link" href="<?php echo e(route('menus',['tag'=>'hamberger2'])); ?>">
												menu Hamberger 2
											</a>
											<a class="nav-link" href="<?php echo e(route('menus',['tag'=>'mobile'])); ?>">
												menu mobile
											</a>
											<a class="nav-link" href="<?php echo e(route('menuMobileTags')); ?>">
												menu tags
											</a>
											<a class="nav-link" href="<?php echo e(route('menuMobile')); ?>">
												menu application mobile
											</a>
										<?php endif; ?>
									</li>
								</ul>
							</li>
						<?php endif; ?>

						<?php if(Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster") || Auth::user()->hasRole("JournalisteWeb") || Auth::user()->hasRole("Journaliste")): ?>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon icon-book-open icons"></i> Posts
								</a>
								<ul class="nav-dropdown-items">
									<?php if(Auth::user()->hasRole("Admin")): ?>
                                    <li class="nav-item">
                                        <a class="nav-link" href="<?php echo e(route('categoriesList')); ?>">
                                            Liste des catégories
                                        </a>
                                    </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="<?php echo e(route('tags.index')); ?>">
                                               Nouveau Tags Predefinis
                                            </a>
                                        </li>
										<li class="nav-item">
											<a class="nav-link" href="<?php echo e(route('newCategory')); ?>">
												Nouvelle catégorie
											</a>
										</li>
									<?php endif; ?>
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('postsList')); ?>">
											Liste des articles
										</a>
									</li>
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('VideosList')); ?>">
											Liste des videos
										</a>
									</li>
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('galleryList')); ?>">
											Gallerie Photo
										</a>
									</li>
								</ul>
							</li>
						<?php endif; ?>

						<?php if(Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster")): ?>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon fa fa-group"></i> Animateurs
								</a>
								<ul class="nav-dropdown-items">
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('animatorsList')); ?>">
											Liste des animateurs
										</a>
									</li>
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('newAnimator')); ?>">
											Nouvel animateur
										</a>
									</li>
								</ul>
							</li>
						<?php endif; ?>

						<?php if(Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster")): ?>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon fa fa-microphone"></i> Emissions
								</a>
								<ul class="nav-dropdown-items">
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('programsList')); ?>">
											Liste des emissions
										</a>
									</li>
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('listPodcasts')); ?>">
											Podcasts
										</a>
									</li>
								</ul>
							</li>
						<?php endif; ?>

						<?php if(Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster") || Auth::user()->hasRole("DiwanKids")): ?>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon fa fa-child"></i> Kids
								</a>
								<ul class="nav-dropdown-items">
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('kidsStoriesList')); ?>">
											Liste des videos
										</a>
									</li>
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('newStory')); ?>">
											Nouvelle video
										</a>
									</li>
								</ul>
							</li>
						<?php endif; ?>

						<?php if(Auth::user()->hasRole("Admin") || Auth::user()->hasRole("ElMarchi")): ?>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon fa fa-shopping-cart"></i> Marchi
								</a>
								<ul class="nav-dropdown-items">
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('marchiCategoriesList')); ?>">
											Liste des catégories
										</a>
									</li>
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('marchiProductsList')); ?>">
											Liste des produits
										</a>
									</li>
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('marchiDays')); ?>">
											Prix du marché
										</a>
									</li>

								</ul>
							</li>
						<?php endif; ?>

						<?php if(Auth::user()->hasRole("Admin")): ?>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon fa fa-bullhorn"></i> Rédacteurs
								</a>
								<ul class="nav-dropdown-items">
									<li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('statRedacteurs')); ?>">
											Statistiques
										</a>
									</li>
								</ul>
							</li>
                        <?php endif; ?>

						<?php if(Auth::user()->hasRole("Admin")): ?>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon fa fa-bullhorn"></i> Pubs
								</a>
								<ul class="nav-dropdown-items">
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('AdsList')); ?>?r=123">
											Liste des pubs
										</a>
									</li>
								</ul>
							</li>
						<?php endif; ?>

						<?php if(Auth::user()->hasRole("Admin")): ?>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon fa fa-mail-reply-all"></i> Newsletter
								</a>
								<ul class="nav-dropdown-items">
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('newsletter')); ?>">
											Liste des inscriptions
										</a>
									</li>
								</ul>
							</li>
						<?php endif; ?>

						<?php if(Auth::user()->hasRole("Admin")): ?>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon fa fa-envelope-o"></i> Contacts
								</a>
								<ul class="nav-dropdown-items">
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('contactsList')); ?>">
											Liste des messages
										</a>
									</li>
								</ul>
							</li>
						<?php endif; ?>
						<?php if(Auth::user()->hasRole("Admin")): ?>
							<li class="nav-item nav-dropdown">
								<a class="nav-link nav-dropdown-toggle" href="#">
									<i class="nav-icon fa fa-bullhorn"></i> notifier
								</a>
								<ul class="nav-dropdown-items">
									<li class="nav-item">
										<a class="nav-link" href="<?php echo e(route('notify')); ?>">
											Envoyer une image ou une nouvelles
										</a>
									</li>
								</ul>
							</li>
						<?php endif; ?>
					</ul>
				</nav>
				<button class="sidebar-minimizer brand-minimizer" type="button"></button>
			</div>

			<main class="main">
				<!-- Breadcrumb-->
		        <ol class="breadcrumb">
		        	<li class="breadcrumb-item">Home</li>
					<?php echo $__env->yieldContent('breadcrumb'); ?>


		        	<!-- Breadcrumb Menu-->
		        	<li class="breadcrumb-menu d-md-down-none">

		        		<div class="btn-group" role="group" aria-label="Button group">
							<?php $__env->startSection("pageTopMenu"); ?>

							<?php echo $__env->yieldSection(); ?>
		        		</div>
		        	</li>
		        </ol>

		        <div class="container-fluid">
		        	<div class="animated fadeIn">
		        		<?php echo $__env->yieldContent('content'); ?>
		        	</div>
		        </div>
			</main>

		</div>

		<footer class="app-footer">
			<div>
				<a taget="_blank" href="http://www.diwanfm.net">Diwan FM</a>
        		<span>&copy; 2018</span>
      		</div>
      		<div class="ml-auto">
        		<span>Powered by</span>
        		<a href="https://piximind.com">PixiMind</a>
      		</div>
    	</footer>

		<script src="<?php echo e(asset('template/js/jquery.min.js')); ?>"></script>
		<script src="<?php echo e(asset('template/js/popper.min.js')); ?>"></script>
		<script src="<?php echo e(asset('template/js/bootstrap.min.js')); ?>"></script>
		<script src="<?php echo e(asset('template/js/perfect-scrollbar.min.js')); ?>"></script>
		<script src="<?php echo e(asset('template/js/pace.min.js')); ?>"></script>
		<script src="<?php echo e(asset('template/js/coreui.min.js')); ?>"></script>
		<script src="<?php echo e(asset('template/plugins/jquery-ui/jquery-ui.min.js')); ?>"></script>
		<script src="<?php echo e(asset('template/plugins/ckeditor/ckeditor.js')); ?>"></script>
		<script src="<?php echo e(asset('template/js/jquery.nestable.js')); ?>"></script>
		<script src="<?php echo e(asset('template/js/select2.full.min.js')); ?>"></script>
		<script src="<?php echo e(asset('template/js/select2.fr.js')); ?>"></script>
		<script src="<?php echo e(asset('template/js/moment.js')); ?>"></script>
		<script src="<?php echo e(asset('template/js/moment.fr.js')); ?>"></script>
		<script src="<?php echo e(asset('template/js/bootstrap-datetimepicker.min.js')); ?>"></script>
		<script>
			var CKoptions = {
				filebrowserImageBrowseUrl: '<?php echo e(url("/elfinder/ckeditor")); ?>',
				filebrowserImageUploadUrl: '<?php echo e(url("/elfinder/ckeditor")); ?>',
				filebrowserBrowseUrl: '<?php echo e(url("/elfinder/ckeditor")); ?>',
				filebrowserUploadUrl: '<?php echo e(url("/elfinder/ckeditor")); ?>'
			};
		</script>
		<?php echo $__env->yieldContent('js'); ?>
		<script>
		    $('#ui-view').ajaxLoad();
		    $(document).ajaxComplete(function() {
		      Pace.restart()
		    });

		    //ckeditor subdomaine fix
		    var fixCkeditorSubDomain=function(){
            $("input[class='cke_dialog_ui_input_text']").each(function(index,value){
                $("#"+value.id).val($("#"+value.id).val().replace("https://nayzak.diwanfm.net/../../diwanfm-frontoff/public/","https://diwanfm.net/"));
            });
            setTimeout(function(){ fixCkeditorSubDomain(); }, 1000);
        }
        setTimeout(function(){ fixCkeditorSubDomain(); }, 1000);
		</script>
	</body>
</html>
