<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item ">
    <a href="<?php echo e(route("categoriesList")); ?>">Categories</a>
</li>
<li class="breadcrumb-item active">
    Editer Catégorie (<?php echo e($category->title); ?>)
</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="<?php echo e(route('editCategory',['categoryId'=>$category->id])); ?>" method="post" id="editForm" >

                <?php echo csrf_field(); ?>


                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer catégory
                    </div>

                    <div class="card-body">

                            <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="title">Titre *</label>
                                            <input class="form-control" type="title" name="title" id="title" value="<?php echo e($category->title); ?>" />
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="meta_title">Titre SEO *</label>
                                            <input class="form-control" type="text" name="meta_title" id="meta_title" value="<?php echo e($category->meta_title); ?>" />
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="keywords">Mots Clés *</label>
                                            <input class="form-control" type="text" name="keywords" id="keywords" value="<?php echo e($category->keywords); ?>" />
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="news_keywords">Mots Clés News *</label>
                                            <input class="form-control" type="text" name="news_keywords" id="news_keywords" value="<?php echo e($category->news_keywords); ?>" />
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="description">Déscription *</label>
                                            <textarea class="form-control" id="description" name="description"><?php echo e($category->description); ?></textarea>
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="isActive">Active</label>
                                            <select class="form-control" id='isActive' name='isActive'>
                                                <option value='0'  <?php if($category->isActive==0): ?> selected='selected' <?php endif; ?>>Inactive</option>
                                                <option value='1'  <?php if($category->isActive==1): ?> selected='selected' <?php endif; ?>>Active</option>
                                            </select>
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="parent">Parent</label>
                                            <select class="form-control" id='parent' name='parent'>
                                                <option value='0' selected="selected" <?php if($category->parent_id==0): ?> selected='selected' <?php endif; ?>></option>
                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($line->id); ?>" <?php if($category->parent_id==$line->id): ?> selected='selected' <?php endif; ?>><?php echo e($line->title); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="color">Couleur catégorie *</label>
                                            <input class="form-control color-picker" type="text" value="<?php echo e($category->color); ?>" name="color" id="color" />
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <input type="hidden" name="habillage" id="habillage" value="<?php echo e($category->habillage); ?>" />
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="habillage_maker">Habillage</label>
                                            <div class="input-group">
                                                <input type="text" class="form-control categoryHabillageSelector" data-photoMaker="<?php echo e(route('PhotoCategoryHabillage')); ?>" value="<?php echo e($category->habillage); ?>" data-original="<?php echo e($category->habillage); ?>" data-dest="habillage" disabled name="habillage_maker" id="habillage_maker" />
                                                <span class="input-group-append">
                                                    <button class="btn btn-primary popup_selector" data-inputid="habillage_maker" type="button">
                                                        <i class="fa fa-photo"></i>
                                                    </button>
                                                </span>
                                                <span class="input-group-append">
                                                    <button class="btn btn-warning popup_selector_colse" data-inputid="habillage_maker" type="button">
                                                        <i class="fa fa-close"></i>
                                                    </button>
                                                </span>
                                            </div>

                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="habillage_link">Lien Habillage</label>
                                            <input class="form-control" type="text" name="habillage_link" id="habillage_link" value="<?php echo e($category->habillage_link); ?>" />
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        var elfinderUrl='<?php echo e(url("/elfinder/popup")); ?>/';
        var storagePath='<?php echo e(config("paths.STORAGE_PATH")); ?>';
    </script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset( 'vendor/colorbox/css/colorbox.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('template/plugins/colorpicker/css/colorpicker.css')); ?>" >
    <script src="<?php echo e(asset('vendor/colorbox/js/jquery.colorbox-min.js')); ?>"></script>
    <script src="<?php echo e(asset('packages/barryvdh/elfinder/js/standalonepopup.js')); ?>"></script>
    <script src="<?php echo e(asset('template/plugins/colorpicker/js/colorpicker.js')); ?>"></script>

    <script src="<?php echo e(asset('js/scripts/categories/edit.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\diwan-backoff\resources\views/categories/edit.blade.php ENDPATH**/ ?>