<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item ">
    <a href="<?php echo e(route("usersList")); ?>">Utilisateurs</a>
</li>
<li class="breadcrumb-item active">
    Editer Utilisateur (<?php echo e($user->name); ?>)
</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="<?php echo e(route('editUser',['userId'=>$user->id])); ?>" method="post" id="editForm" >

                <?php echo csrf_field(); ?>


                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        <?php echo trans("diwan.Edit user"); ?>

                    </div>

                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="email">Email</label>
                                    <input class="form-control" type="email" name="email" value="<?php echo e($user->email); ?>" id="email" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="name">Nom & Prénom</label>
                                    <input class="form-control" type="text" name="name" value="<?php echo e($user->name); ?>" id="name" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>
                        
                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">Roles</label>
                            <div class="col-md-9 col-form-label">
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check checkbox">
                                        <input class="form-check-input" name="roles[]" type="checkbox" id="role-<?php echo e($role->id); ?>" value="<?php echo e($role->id); ?>" <?php if($user->hasRole($role->name)): ?> checked <?php endif; ?> >
                                        <label class="form-check-label" for="role-<?php echo e($role->id); ?>"><?php echo e($role->name); ?></label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/scripts/users/edit.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\diwan-backoff\resources\views/users/edit.blade.php ENDPATH**/ ?>