<?php $__env->startSection("breadcrumb"); ?>
    <li class="breadcrumb-item active">Tags Predefinis</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("pageTopMenu"); ?>
    <a class="btn" href="<?php echo e(route('tags.create')); ?>"> Create New Tags</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Liste des Tags Predefinis
                    </div>
                    <div class="card-body">


                        <?php if($message = Session::get('success')): ?>
                            <div class="alert alert-success">
                                <p><?php echo e($message); ?></p>
                            </div>
                        <?php endif; ?>
                        <table class="table table-responsive-sm table-striped">
                            <thead>
                            <tr>
                                <td>No</td>
                                <td>Name</td>
                                <td>Action</td>
                            </tr>
                            </thead>

                            <tbody>
                            <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(++$i); ?></td>
                                    <td><?php echo e($tag->name); ?></td>
                                    <td>
                                        <form action="<?php echo e(route('tags.destroy',$tag->id)); ?>" method="POST">

                                            <a class="btn btn-sm btn-primary" href="<?php echo e(route('tags.edit',$tag->id)); ?>">Edit</a>

                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>

                                            <button type="submit" class="btn btn-sm btn-warning">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                        <?php echo $tags->links(); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>