<?php $__env->startSection('content'); ?>
<h1><?php echo trans('diwan.login'); ?></h1>
<p class="text-muted"><?php echo trans('diwan.SignInYourAccount'); ?></p>

<form method="POST" action="<?php echo e(route('login')); ?>">

    <?php echo csrf_field(); ?>

    <div class="input-group mb-3">
        <div class="input-group-prepend">
            <span class="input-group-text">
                <i class="icon-user"></i>
            </span>
        </div>
        <input class="form-control <?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" type="email" id="email" name="email" required autofocus value="<?php echo e(old('email')); ?>" placeholder="<?php echo trans('diwan.Email Adress'); ?>">
        <?php if($errors->has('email')): ?>
            <span class="invalid-feedback" role="alert">
                <strong><?php echo e($errors->first('email')); ?></strong>
            </span>
        <?php endif; ?>
    </div>

    <div class="input-group mb-3">
        <div class="input-group-prepend">
            <span class="input-group-text">
                <i class="icon-lock"></i>
            </span>
        </div>
        <input class="form-control <?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>" type="password" id="password" name="password" required autofocus value="<?php echo e(old('password')); ?>" placeholder="<?php echo trans('diwan.Password'); ?>">
        <?php if($errors->has('password')): ?>
            <span class="invalid-feedback" role="alert">
                <strong><?php echo e($errors->first('password')); ?></strong>
            </span>
        <?php endif; ?>
    </div>

    <div class="form-check form-check-inline mr-1">
        <input class="form-check-input" id="remember" type="checkbox" name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
        <label class="form-check-label" for="remember"><?php echo trans('diwan.Remember Me'); ?></label>
    </div>

    <div class="row">
        <div class="col-12">
            <button class="btn btn-primary px-4" type="submit"><?php echo trans('diwan.login'); ?></button>
        </div>
    </div>

</form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.loginLayout', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>