<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item active">
    Kids Migrator
</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("pageTopMenu"); ?>
    <a class="btn" href="#" id="lanchMigration">Lancer la migration</a>
    <input type="hidden" id="csrf" value="<?php echo e(csrf_token()); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="card">

                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Liste des modules
                    </div>

                    <div class="card-body">
                        <table class="table table-responsive-sm table-striped">
                            <thead>
                                <tr>
                                    <td>Module</td>
                                    <td>Etat</td>
                                    <td>Progression</td>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        Categories
                                    </td>
                                    <td id="categoriesModuleState">
                                        En attente
                                    </td>
                                    <td id="categoriesModuleProgress">
                                        0%
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Stories
                                    </td>
                                    <td id="storiesModuleState">
                                        En attente
                                    </td>
                                    <td id="storiesModuleProgress">
                                        0%
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<script>

    var categories=[];
    var stories=[];
    
    //lanch function
    lanchMigration=function(){
        scriptState=1;
        getCategories();
    }

    //getCategories function
    getCategories=function(){

        $("#categoriesModuleState").html("En cours");
        $.ajax({
            url:"<?php echo e(route('migratorKidsCategories')); ?>",
            method:"get",
            dataType:"json",
            success:function(data){
                categories=data.categories;
                $("#categoriesModuleState").html("Términé");
                $("#categoriesModuleProgress").html("100%");
                getStories();
            }
        });
    }

    //get programs
    getStories=function(){
        $("#storiesModuleState").html("Récupération des données");
        $.ajax({
            url:"<?php echo e(route('migratorKidsStories')); ?>",
            method:"get",
            dataType:"json",
            success:function(data){
                stories=data.stories;
                $("#kidsModuleState").html("En cours");
                var intRef=setInterval(function(){
                    notreadyfilter=stories.filter(function(oneStory){
                        return (oneStory!=null && oneStory.newID==undefined);
                    });
                    if(notreadyfilter.length==0){
                        clearInterval(intRef);
                        $("#storiesModuleProgress").html("100%");
                        $("#storiesModuleState").html("Terminé");
                        //continue
                        
                    }else{
                        var pourcentage=100-Math.round((100*notreadyfilter.length)/stories.length);
                        $("#storiesModuleProgress").html(pourcentage+"%");
                    }
                },1000);
                i=0;
                var saveRef=setInterval(function(){
                    saveStory(i);
                    i++;
                    if(i==stories.length){
                        clearInterval(saveRef);
                    }
                },300);                
            }
        });
    }

    //save story
    saveStory=function(index){
        thisStory=stories[index];
        if(thisStory!=null){
            var thisCategory=null;
            for(j=0;j<categories.length;j++){
                if(categories[j].id==thisStory.category){
                    thisCategory=categories[j];
                }
            }

            $.ajax({
                url:"<?php echo e(route('migratorSaveStory')); ?>",
                method:"post",
                data:"record="+JSON.stringify(stories[index])+"&category="+thisCategory.newId,
                dataType:"json",
                success:function(storyData){
                    stories[index]=storyData;
                }
            });
        }
        
    }

    //get seances
    getSeances=function(){
        $("#programsSeancesModuleState").html("Récupération des données");
        $.ajax({
            url:"<?php echo e(route('migratorProgramsSeances')); ?>",
            method:"get",
            dataType:"json",
            success:function(data){
                programsSeances=data.programsSeances;
                $("#programsSeancesModuleState").html("En cours");
                var intRef=setInterval(function(){
                    notreadyfilter=programsSeances.filter(function(oneProgramSeance){
                        return (oneProgramSeance.newID==undefined);
                    });
                    if(notreadyfilter.length==0){
                        clearInterval(intRef);
                        $("#programsSeancesModuleProgress").html("100%");
                        $("#programsSeancesModuleState").html("Terminé");
                        //continue
                        getPodcasts();
                        
                    }else{
                        var pourcentage=100-Math.round((100*notreadyfilter.length)/programsSeances.length);
                        $("#programsSeancesModuleProgress").html(pourcentage+"%");
                    }
                },1000);
                i=0;
                var saveRef=setInterval(function(){
                    saveProgramSeance(i);
                    i++;
                    if(i==programsSeances.length){
                        clearInterval(saveRef);
                    }
                },300);                
            }
        });
    }

    //save seances
    saveProgramSeance=function(index){
        thisSeance=programsSeances[index];
        var thisProgram=null;
        for(j=0;j<programs.length;j++){
            if(programs[j].program.program_id==thisSeance.program_id){
                thisProgram=programs[j];
            }
        }
        if(thisProgram!=null){
            $.ajax({
                url:"<?php echo e(route('migratorSaveProgramSeance')); ?>",
                method:"post",
                /*headers:{
                    'X-CSRF-TOKEN': $('#csrf').val()
                },*/
                data:"seance="+JSON.stringify(programsSeances[index])+"&program="+JSON.stringify(thisProgram.newID),
                dataType:"json",
                success:function(programData){
                    programsSeances[index]=programData.programSeance;
                }
            });
        }else{
            programsSeances[index].newID=0;
        }
        
    }


    //get podcasts
    getPodcasts=function(){
        $("#podcastsModuleState").html("Récupération des données");
        $.ajax({
            url:"<?php echo e(route('migratorPodcasts')); ?>",
            method:"get",
            dataType:"json",
            success:function(data){
                podcasts=data.podcasts;
                $("#podcastsModuleState").html("En cours");
                var intRef=setInterval(function(){
                    notreadyfilter=podcasts.filter(function(onePodcast){
                        return (onePodcast!=null && onePodcast.newID==undefined);
                    });
                    if(notreadyfilter.length==0){
                        clearInterval(intRef);
                        $("#podcastsModuleProgress").html("100%");
                        $("#podcastsModuleState").html("Terminé");
                        //continue
                        
                    }else{
                        var pourcentage=100-Math.round((100*notreadyfilter.length)/podcasts.length);
                        $("#PodcastsModuleProgress").html(pourcentage+"%");
                    }
                },1000);
                i=0;
                var saveRef=setInterval(function(){
                    if(podcasts[i]!=null){
                        savePodcast(i);
                    }
                    console.log(i);
                    i++;
                    if(i==podcasts.length){
                        clearInterval(saveRef);
                    }
                },300);        
            }
        });
    }

    //save seances
    savePodcast=function(index){
        thisPodcast=podcasts[index];

        thisSeance=programsSeances.filter(function(oneSeance){
            return (oneSeance.progcategory_id==podcasts[index].progcategory_id);
        });
        

        /*thisProgram=programs.filter(function(oneProgram){
            return (oneProgram.program.program_id==podcasts[index].program_id);
        });*/
        var thisProgram=null;
        for(j=0;j<programs.length;j++){
            if(programs[j].program.program_id==thisPodcast.program_id){
                thisProgram=programs[j];
            }
        }
        var thisSeance=null;
        for(j=0;j<programsSeances.length;j++){
            if(programsSeances[j].progcategory_id==thisPodcast.progcategory_id){
                thisSeance=programsSeances[j];
            }
        }
        if(thisProgram!=null && thisSeance!=null && thisSeance.newID!=0){
            $.ajax({
                url:"<?php echo e(route('migratorSavePodcast')); ?>",
                method:"post",
                /*headers:{
                    'X-CSRF-TOKEN': $('#csrf').val()
                },*/
                data:"podcast="+JSON.stringify(podcasts[index])+"&program="+thisProgram.newID+"&seance="+thisSeance.newID,
                dataType:"json",
                success:function(podcastData){
                    podcasts[index]=podcastData.podcast;
                }
            });
        }else{
            podcasts[index].newID=0;
        }
        
    }

    //lanch script
    $(document).ready(function(){
        $("#lanchMigration").on("click",function(e){
            e.preventDefault();
            lanchMigration();
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>