<?php $__env->startSection("breadcrumb"); ?>
    <li class="breadcrumb-item ">
        <a href="<?php echo e(route('marchiProductsList')); ?>">El marchi</a>
    </li>
    <li class="breadcrumb-item active">
        Produits
    </li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("pageTopMenu"); ?>
    <a class="btn" href="<?php echo e(route('newMarchiProduct')); ?>">+ Ajouter produit</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo csrf_field(); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des produits
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Titre</td>
                                <td>Catégorie</td>
                                <td>Description</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($product->id); ?></td>
                                    <td><?php echo e($product->title); ?></td>
                                    <td><?php echo e($product->marchiCategory->title); ?></td>
                                    <td><?php echo e($product->summary); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('editMarchiProduct',['marchiProduct'=>$product->id])); ?>" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="<?php echo e(route('deleteMarchiProduct',['marchiProduct'=>$product->id])); ?>" class="btn btn-sm btn-warning deleteProduct">Supprimer</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr><td colspan="5">Pas de produit pour le moment</td></tr>
                            <?php endif; ?>
                        </tbody>

                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('js/scripts/marchi/delete-product.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\diwan-backoff\resources\views/marchi/list-product.blade.php ENDPATH**/ ?>