<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item active">Newsletter</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo csrf_field(); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des inscriptions
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Email</td>
                                <td>Adresse Ip</td>
                                <td>Date</td>
                                <td>Annulé</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($subscription->id); ?></td>
                                    <td><?php echo e($subscription->email); ?></td>
                                    <td><?php echo e($subscription->created_at->format("d/m/Y")); ?></td>
                                    <td><?php echo e($subscription->ip); ?></td>
                                    <td>
                                        <?php if($subscription->canceled): ?>
                                            Oui
                                        <?php else: ?>
                                            Non
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('deleteNewsletterSubscription',['subscriptionId'=>$subscription->id])); ?>" class="btn btn-sm btn-warning deleteSubscription">Supprimer</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>

                    <?php echo e($subscriptions->onEachSide(5)->links()); ?>

                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/scripts/newsletter/delete.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>