

<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item ">
    <a href="<?php echo e(route('programsList')); ?>">Liste des emissions</a>
</li>
<li class="breadcrumb-item ">
    <a href="<?php echo e(route('programming',['programId'=>$programming->program->id])); ?>">Programmation (<?php echo e($programming->program->title); ?>) </a>
</li>
<li class="breadcrumb-item active">
    Editer programmation
</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="<?php echo e(route('ajxUpdateProgramming',['programId'=>$programming->program->id,'programmingId'=>$programming->id])); ?>" method="post" id="editForm" >

                <?php echo csrf_field(); ?>


                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer programmation
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="day">Jour *</label>
                                    <select class="form-control" name="day" id="day">
                                        <option value="1" <?php if($programming->day==1): ?> selected="selected" <?php endif; ?> ><?php echo trans('days.1'); ?></option>
                                        <option value="2" <?php if($programming->day==2): ?> selected="selected" <?php endif; ?> ><?php echo trans('days.2'); ?></option>
                                        <option value="3" <?php if($programming->day==3): ?> selected="selected" <?php endif; ?> ><?php echo trans('days.3'); ?></option>
                                        <option value="4" <?php if($programming->day==4): ?> selected="selected" <?php endif; ?> ><?php echo trans('days.4'); ?></option>
                                        <option value="5" <?php if($programming->day==5): ?> selected="selected" <?php endif; ?> ><?php echo trans('days.5'); ?></option>
                                        <option value="6" <?php if($programming->day==6): ?> selected="selected" <?php endif; ?> ><?php echo trans('days.6'); ?></option>
                                        <option value="7" <?php if($programming->day==7): ?> selected="selected" <?php endif; ?> ><?php echo trans('days.7'); ?></option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="start_time">Heure Début *</label>
                                    <input class="form-control" value="<?php echo e($programming->start_time); ?>" type="text" name="start_time" id="start_time" />
                                    
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="end_time">Heure Fin *</label>
                                    <input class="form-control" value="<?php echo e($programming->end_time); ?>" type="text" name="end_time" id="end_time" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" id="onair" name="onair" <?php if($programming->onair): ?> checked="checked" <?php endif; ?> type="checkbox" value="1">
                                        <label class="form-check-label" for="onair">OnAir</label>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

    <script src="<?php echo e(asset('js/scripts/programs/edit-programming.js')); ?>"></script>

    <script>
        $(document).ready(function(){
            $("#start_time").datetimepicker({
                format:"HH:mm:ss"
            });
            $("#end_time").datetimepicker({
                format:"HH:mm:ss"
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>