<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item active">Animateurs</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo csrf_field(); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des animateurs
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Nom</td>
                                <td>Visible</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $animators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $animator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($animator->id); ?></td>
                                    <td><?php echo e($animator->name); ?></td>
                                    <td>
                                        <?php if($animator->public==0): ?>
                                            Non
                                        <?php else: ?>
                                            Oui
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('editAnimator',['animatorId'=>$animator->id])); ?>" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="<?php echo e(route('deleteAnimator',['animatorId'=>$animator->id])); ?>" class="btn btn-sm btn-warning deleteAnimator">Supprimer</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>

                    <?php echo e($animators->onEachSide(5)->links()); ?>

                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/scripts/animators/delete.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>