

<?php $__env->startSection("breadcrumb"); ?>
    <li class="breadcrumb-item ">
        <a href="<?php echo e(route('marchiProductsList')); ?>">El marchi</a>
    </li>
    <li class="breadcrumb-item active">
        Liste des jours
    </li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("pageTopMenu"); ?>
    <a class="btn" href="<?php echo e(route('newMarchiDay')); ?>">+ Ajouter un jour</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo csrf_field(); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des jours
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>Date</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($day->day_date); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('editMarchiDay',['day'=>$day->day_date])); ?>" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="<?php echo e(route('deleteMarchiday',['day'=>$day->day_date])); ?>" class="btn btn-sm btn-warning deleteDay">Supprimer</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>

                    <?php echo e($days->onEachSide(5)->links()); ?>

                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('js/scripts/marchi/delete-day.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>