

<?php $__env->startSection("breadcrumb"); ?>
    <li class="breadcrumb-item ">
        <a href="<?php echo e(route('marchiProductsList')); ?>">El marchi</a>
    </li>
    <li class="breadcrumb-item ">
        <a href="<?php echo e(route('marchiCategoriesList')); ?>">Catégories</a>
    </li>
    <li class="breadcrumb-item active">
        Editer Catégorie (<?php echo e($category->title); ?>)
    </li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="<?php echo e(route('ajxUpdateMarchiCategory',['category'=>$category->id])); ?>" method="post" id="editForm" >

                <?php echo csrf_field(); ?>


                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer Catégorie
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="text" value="<?php echo e($category->title); ?>" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_title">Titre SEO *</label>
                                    <input class="form-control" type="text" value="<?php echo e($category->meta_title); ?>" name="meta_title" id="meta_title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>


                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_keywords">Mots Clés *</label>
                                    <input class="form-control" type="text" value="<?php echo e($category->meta_keywords); ?>" name="meta_keywords" id="meta_keywords" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-col-form-label" for="order">Ordre *</label>
                                        <select class="form-control" name="order" id="order">
                                            <?php for($i=1;$i<=$cntCat;$i++): ?>
                                                <option value="<?php echo e($i); ?>" <?php if($category->order==$i): ?> selected="selected" <?php endif; ?>><?php echo e($i); ?></option>
                                            <?php endfor; ?>
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="summary">Déscription *</label>
                                    <textarea class="form-control" id="summary" name="summary"><?php echo e($category->summary); ?></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_description">Déscription SEO *</label>
                                    <textarea class="form-control" id="meta_description" name="meta_description"><?php echo e($category->meta_description); ?></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_maker">Image *</label>
                                    
                                    <div class="input-group">
                                        <input type="text" value="<?php echo e($category->img); ?>" class="form-control imgSelector" data-photoMaker="<?php echo e(route('PhotoMarchiCategory')); ?>" data-original="<?php echo e($category->img); ?>" disabled name="img_maker" data-dest="img" id="img_maker" />
                                        <span class="input-group-append">
                                            <button class="btn btn-primary popup_selector" data-inputid="img_maker" type="button">
                                                <i class="fa fa-photo"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-warning popup_selector_colse" data-inputid="img_maker" type="button">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-success popup_selector_visualize" href="<?php echo e(config("paths.PHOTOS_URL").'marchi/category/'.$category->img); ?>" data-inputid="img_maker" type="button">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </span>
                                    </div>
                                    <input type="hidden" value="<?php echo e($category->img); ?>" class="form-control" name="img" id="img" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_alt">Alt image*</label>
                                    <input class="form-control" value="<?php echo e($category->img_alt); ?>" type="text" name="img_alt" id="img_alt" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        var elfinderUrl='<?php echo e(url("/elfinder/popup")); ?>/';
        var storagePath='<?php echo e(config("paths.STORAGE_PATH")); ?>';
        var photosUrl='<?php echo e(config("paths.PHOTOS_URL")); ?>';
    </script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset( 'vendor/colorbox/css/colorbox.css')); ?>">
    <script src="<?php echo e(asset('vendor/colorbox/js/jquery.colorbox-min.js')); ?>"></script>
    <script src="<?php echo e(asset('packages/barryvdh/elfinder/js/standalonepopup.js')); ?>"></script>
    
    <script src="<?php echo e(asset('js/scripts/marchi/edit-category.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>