<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item active">Kids</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("pageTopMenu"); ?>
    <a class="btn" href="<?php echo e(route('newStory')); ?>">+ Ajouter video</a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo csrf_field(); ?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des videos
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Titre</td>
                                <td>Catégorie</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $stories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $story): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($story->id); ?></td>
                                    <td><?php echo e($story->title); ?></td>
                                    <td>
                                        <?php echo e($story->category->title); ?>

                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('editStory',['storyId'=>$story->id])); ?>" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="<?php echo e(route('deleteStory',['storyId'=>$story->id])); ?>" class="btn btn-sm btn-warning deletePost">Supprimer</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                    <?php echo e($stories->onEachSide(5)->links()); ?>

                    
                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/scripts/kids/delete-story.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>