

<?php $__env->startSection("breadcrumb"); ?>
<li class="breadcrumb-item ">
    <a href="<?php echo e(route('animatorsList')); ?>">Liste des animateurs</a>
</li>
<li class="breadcrumb-item active">
    Editer animateur (<?php echo e($animator->name); ?>)
</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="<?php echo e(route('ajxUpdateAnimator',['animatorId'=>$animator->id])); ?>" method="post" id="editForm" >

                <?php echo csrf_field(); ?>


                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer animateur
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Nom *</label>
                                    <input class="form-control" type="text" value="<?php echo e($animator->name); ?>" name="name" id="name" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="public">Visible</label>
                                    <select class="form-control" id='public' name='public'>
                                        <option value="0"  <?php if($animator->public==0): ?> selected="selected" <?php endif; ?>>Non</option>
                                        <option value="1"  <?php if($animator->public==1): ?> selected="selected" <?php endif; ?>>Oui</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="description">Déscription *</label>
                                    <textarea class="form-control" id="description" name="description"><?php echo e($animator->description); ?></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_description">Déscription SEO *</label>
                                    <textarea class="form-control" id="meta_description" name="meta_description"><?php echo e($animator->meta_description); ?></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_keywords">Mots Clés *</label>
                                    <input class="form-control" type="text" value="<?php echo e($animator->meta_keywords); ?>" name="meta_keywords" id="meta_keywords" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="tag">Tag *</label>
                                    <input class="form-control" type="text" value="<?php echo e($animator->tag); ?>" name="tag" id="tag" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_maker">Image *</label>
                                    
                                    <div class="input-group">
                                        <input type="text" class="form-control imgSelector" value="<?php echo e($animator->img); ?>" data-photoMaker="<?php echo e(route('PhotoAnimator')); ?>" data-original="<?php echo e($animator->img); ?>" disabled name="img_maker" data-dest="img" id="img_maker" />
                                        <span class="input-group-append">
                                            <button class="btn btn-primary popup_selector" data-inputid="img_maker" type="button">
                                                <i class="fa fa-photo"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-warning popup_selector_colse" data-inputid="img_maker" type="button">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-success popup_selector_visualize" href="<?php echo e(config("paths.PHOTOS_URL").'animators/'.$animator->img); ?>" data-inputid="img_maker" type="button">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </span>
                                    </div>
                                    <input type="hidden" class="form-control" value="<?php echo e($animator->img); ?>" name="img" id="img" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_alt">Alt image*</label>
                                    <input class="form-control" value="<?php echo e($animator->img_alt); ?>" type="text" name="img_alt" id="img_alt" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        var elfinderUrl='<?php echo e(url("/elfinder/popup")); ?>/';
        var storagePath='<?php echo e(config("paths.STORAGE_PATH")); ?>';
        var photosUrl='<?php echo e(config("paths.PHOTOS_URL")); ?>';
    </script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset( 'vendor/colorbox/css/colorbox.css')); ?>">
    <script src="<?php echo e(asset('vendor/colorbox/js/jquery.colorbox-min.js')); ?>"></script>
    <script src="<?php echo e(asset('packages/barryvdh/elfinder/js/standalonepopup.js')); ?>"></script>
    
    <script src="<?php echo e(asset('js/scripts/animators/edit.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dwtemplate.index', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>