<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

Route::get('FixTags/{tag_name}','TagsController@FixTags')->name('FixTags');
Route::get('getAllTagsCleanUp','TagsController@getAllTagsCleanUp')->name('getAllTagsCleanUp');

// Route::group(['middleware'=>["auth","activeUser","passwordChanged","dwTFA"]],function(){
//Route::group(['middleware'=>["auth","activeUser","dwTFA"]],function(){

    Route::get('/redacteurs/stats', 'HomeController@statRedacteurs')->name('statRedacteurs');
    Route::post('/redacteurs/stats', 'HomeController@statRedacteursFilter')->name('statFilter');
    Route::get('/', 'HomeController@index');
    Route::get('/accueil', 'HomeController@index')->name('home');
    Route::get('/tags/list','TagsController@ajaxList')->name("tagsAjaxList");
    Route::resource('/tags','TagsController');


    // Social Users
    Route::get('/social-users', 'SocialUserController@index')->name('socialUsersList')->middleware('checkRoles:Admin');

    Route::post('/social-users/desactive', 'SocialUserController@desactivate')->name('socialUserDesactivate')->middleware('checkRoles:Admin');
    Route::post('/social-users/activate', 'SocialUserController@activate')->name('socialUserActivate')->middleware('checkRoles:Admin');

    // End social Users
    Route::get('/users', 'UserController@index')->name('usersList')->middleware('checkRoles:Admin');
    Route::post('/users/desactive', 'UserController@desactivate')->name('userDesactivate')->middleware('checkRoles:Admin');
    Route::post('/users/activate', 'UserController@activate')->name('userActivate')->middleware('checkRoles:Admin');
    Route::get('/users/create', 'UserController@newUser')->name('newUser')->middleware('checkRoles:Admin');
    Route::post('/users/create', 'UserController@ajxNewUser')->name('ajxNewUser')->middleware('checkRoles:Admin');
    Route::get('/users/edit/{userId}', 'UserController@edit')->name('editUser')->middleware('checkRoles:Admin');
    Route::post('/users/edit/{userId}', 'UserController@ajxUpdateUser')->name('ajxUpdateUser')->middleware('checkRoles:Admin');
    Route::get('/users/edit_password/{userId}', 'UserController@editPassword')->name('editUserPassword')->middleware('checkRoles:Admin');
    Route::post('/users/edit_password/{userId}', 'UserController@ajxUpdateUserPassword')->name('ajxUpdateUserPassword')->middleware('checkRoles:Admin');

    Route::get('/pages', 'PageController@index')->name('pagesList')->middleware('checkRoles:Admin,Webmaster');
    Route::get('/pages/create', 'PageController@newPage')->name('newPage')->middleware('checkRoles:Admin,Webmaster');
    Route::post('/pages/create', 'PageController@ajxNewPage')->name('ajxNewPage')->middleware('checkRoles:Admin,Webmaster');
    Route::get('/pages/edit/{pageId}', 'PageController@edit')->name('editPage')->middleware('checkRoles:Admin,Webmaster');
    Route::post('/pages/edit/{pageId}', 'PageController@ajxUpdatePage')->name('ajxUpdatePage')->middleware('checkRoles:Admin,Webmaster');
    Route::delete('/pages/delete/{pageId}', 'PageController@delete')->name('deletePage')->middleware('checkRoles:Admin,Webmaster');

    /*Route::get('/menu/secondaire','MenuController@list')->name('menusSecondaire')->middleware('checkRoles:Admin,Webmaster,MenuSecondaire');
    Route::get('/menus/secondaire/new','MenuController@newMenu')->name('newMenuSecondaire')->middleware('checkRoles:Admin,Webmaster,MenuSecondaire');
    Route::post('/menus/secondaire/new','MenuController@ajxNewMenu')->name('ajxNewMenuSecondaire')->middleware('checkRoles:Admin,Webmaster,MenuSecondaire');
    Route::post('/menus/secondaire','MenuController@ajxUpdatelist')->name('ajxAupdateMenusSecondaire')->middleware('checkRoles:Admin,Webmaster,MenuSecondaire');
    Route::get('/menus/secondaire/edit/{menuId}','MenuController@edit')->name('editMenuSecondaire')->middleware('checkRoles:Admin,Webmaster,MenuSecondaire');
    Route::post('/menus/secondaire/edit/{menuId}','MenuController@ajaxUpdateMenu')->name('ajaxUpdateMenuSecondaire')->middleware('checkRoles:Admin,Webmaster,MenuSecondaire');
    Route::delete('/menus/secondaire/delete/{menuId}', 'MenuController@delete')->name('deleteMenuSecondaire')->middleware('checkRoles:Admin,Webmaster,MenuSecondaire');*/

    /*Route::get('/menu/{tag}','MenuController@list')->name('menus')->middleware('checkRoles:Admin,Webmaster');
    Route::get('/menus/{tag}/new','MenuController@newMenu')->name('newMenu')->middleware('checkRoles:Admin,Webmaster');
    Route::post('/menus/{tag}/new','MenuController@ajxNewMenu')->name('ajxNewMenu')->middleware('checkRoles:Admin,Webmaster');
    Route::post('/menus/{tag}','MenuController@ajxUpdatelist')->name('ajxAupdateMenus')->middleware('checkRoles:Admin,Webmaster');
    Route::get('/menus/{tag}/edit/{menuId}','MenuController@edit')->name('editMenu')->middleware('checkRoles:Admin,Webmaster');
    Route::post('/menus/{tag}/edit/{menuId}','MenuController@ajaxUpdateMenu')->name('ajaxUpdateMenu')->middleware('checkRoles:Admin,Webmaster');
    Route::delete('/menus/{tag}/delete/{menuId}', 'MenuController@delete')->name('deleteMenu')->middleware('checkRoles:Admin,Webmaster');*/


    Route::get('/menuMobileTags/tags','MenuController@listMobileTags')->name('menuMobileTags');
    Route::post('/menuMobileTags/tags','MenuController@ajxUpdatelistMobileTags')->name('ajxAupdateMenusMobileTags');
    Route::get('/menuMobileTags/tags/newMobileTags','MenuController@newMenuMobileTags')->name('newMenuMobileTags');
    Route::post('/menuMobileTags/tags/newMobileTags','MenuController@ajxNewMenuMobileTags')->name('ajxNewMenuMobileTags');
    Route::get('/menuMobileTags/tags/editMobileTags/{menuId}','MenuController@editMobileTags')->name('editMenuMobileTags');
    Route::post('/menuMobileTags/tags/edit/{menuId}','MenuController@ajaxUpdateMenuMobileTags')->name('ajaxUpdateMenuMobileTags');
    Route::delete('/menuMobileTags/tags/deleteMobileTags/{menuId}', 'MenuController@deleteMobileTags')->name('deleteMenuMobileTags');

    Route::get('/menuMobile/menuMobile','MenuController@listMobile')->name('menuMobile');
    Route::get('/menuMobile/menuMobile/newMobile','MenuController@newMenuMobile')->name('newMenuMobile');
    Route::post('/menuMobile/menuMobile/newMobile','MenuController@ajxNewMenuMobile')->name('ajxNewMenuMobile');
    Route::post('/menuMobile/menuMobile','MenuController@ajxUpdatelistMobile')->name('ajxAupdateMenusMobile');
    Route::get('/menuMobile/menuMobile/editMobile/{menuId}','MenuController@editMobile')->name('editMenuMobile');
    Route::post('/menuMobile/menuMobile/edit/{menuId}','MenuController@ajaxUpdateMenuMobile')->name('ajaxUpdateMenuMobile');
    Route::delete('/menuMobile/menuMobile/deleteMobile/{menuId}', 'MenuController@deleteMobile')->name('deleteMenuMobile');

    Route::get('/menu/{tag}','MenuController@list')->name('menus');
    Route::get('/menus/{tag}/new','MenuController@newMenu')->name('newMenu');
    Route::post('/menus/{tag}/new','MenuController@ajxNewMenu')->name('ajxNewMenu');
    Route::post('/menus/{tag}','MenuController@ajxUpdatelist')->name('ajxAupdateMenus');
    Route::get('/menus/{tag}/edit/{menuId}','MenuController@edit')->name('editMenu');
    Route::post('/menus/{tag}/edit/{menuId}','MenuController@ajaxUpdateMenu')->name('ajaxUpdateMenu');
    Route::delete('/menus/{tag}/delete/{menuId}', 'MenuController@delete')->name('deleteMenu');

    Route::get('/categories','CategoryController@index')->name('categoriesList')->middleware('checkRoles:Admin');
    Route::get('/categories/create','CategoryController@newCategory')->name('newCategory')->middleware('checkRoles:Admin');
    Route::post('/categories/create', 'CategoryController@ajxNewCategory')->name('ajxNewCategory')->middleware('checkRoles:Admin');
    Route::get('/categories/edit/{categoryId}', 'CategoryController@edit')->name('editCategory')->middleware('checkRoles:Admin');
    Route::post('/categories/edit/{categoryId}', 'CategoryController@ajxUpdateCategory')->name('ajxUpdateCategory')->middleware('checkRoles:Admin');
    Route::delete('/categories/delete/{categoryId}', 'CategoryController@delete')->name('deleteCategory')->middleware('checkRoles:Admin');

    Route::get('/posts_list','PostController@index')->name("postsList")->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/posts/creates', 'PostController@newArticle')->name('newArticle')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::post('/posts/create', 'PostController@ajxNewArticle')->name('ajxNewArticle');
    Route::get('/posts/edit/{postId}', 'PostController@editArticle')->name('editArticle')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::post('/posts/edit/{postId}', 'PostController@ajxUpdateArticle')->name('ajxUpdateArticle')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::delete('/posts/delete/{postId}', 'PostController@deleteArticle')->name('deleteArticle')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/videos','PostController@listVideo')->name("VideosList")->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/videos/create_video', 'PostController@newVideo')->name('newVideo')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::post('/videos/create_video', 'PostController@ajxNewVideo')->name('ajxNewVideo')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/videos/edit/{videoId}', 'PostController@editVideo')->name('editVideo')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::post('/videos/edit/{videoId}', 'PostController@ajxUpdateVideo')->name('ajxUpdateVideo')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::delete('/videos/delete/{videoId}', 'PostController@deleteVideo')->name('deleteVideo')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/gallery','PostController@listGallery')->name("galleryList")->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/gallery/create_gallery', 'PostController@newGallery')->name('newGallery')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::post('/gallery/create_gallery', 'PostController@ajxNewGallery')->name('ajxNewGallery')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/gallery/edit/{galleryId}', 'PostController@editGallery')->name('editGallery')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::post('/gallery/edit/{galleryId}', 'PostController@ajxUpdateGallery')->name('ajxUpdateGallery')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::delete('/gallery/delete/{galleryId}', 'PostController@deleteGallery')->name('deleteGallery')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');

    Route::get('/animators','AnimatorController@index')->name("animatorsList")->middleware('checkRoles:Admin,Webmaster');
    Route::get('/animators/create', 'AnimatorController@newAnimator')->name('newAnimator')->middleware('checkRoles:Admin,Webmaster');
    Route::post('/animators/create', 'AnimatorController@ajxNewAnimator')->name('ajxNewAnimator')->middleware('checkRoles:Admin,Webmaster');
    Route::get('/animators/edit/{animatorId}','AnimatorController@edit')->name("editAnimator")->middleware('checkRoles:Admin,Webmaster');
    Route::post('/animators/edit/{animatorId}', 'AnimatorController@ajxUpdateAnimator')->name('ajxUpdateAnimator')->middleware('checkRoles:Admin,Webmaster');
    Route::delete('/animators/delete/{animatorId}', 'AnimatorController@delete')->name('deleteAnimator')->middleware('checkRoles:Admin,Webmaster');

    Route::get('/programs','ProgramController@index')->name("programsList")->middleware('checkRoles:Admin,Webmaster');
    Route::get('/programs/create', 'ProgramController@newProgram')->name('newProgram')->middleware('checkRoles:Admin,Webmaster');
    Route::post('/programs/create', 'ProgramController@ajxNewProgram')->name('ajxNewProgram')->middleware('checkRoles:Admin,Webmaster');
    Route::get('/programs/edit/{programId}','ProgramController@edit')->name("editProgram")->middleware('checkRoles:Admin,Webmaster');
    Route::post('/programs/edit/{programId}', 'ProgramController@ajxUpdateProgram')->name('ajxUpdateProgram')->middleware('checkRoles:Admin,Webmaster');
    Route::delete('/programs/delete/{programId}', 'ProgramController@delete')->name('deleteProgram')->middleware('checkRoles:Admin,Webmaster');
    Route::get('/programs/{programId}/seances', 'ProgramController@seances')->name('programSeances')->middleware('checkRoles:Admin,Webmaster');
    Route::get('/programs/{programId}/seances/create', 'ProgramController@newProgramSeance')->name('createProgramSeance')->middleware('checkRoles:Admin,Webmaster');
    Route::post('/programs/{programId}/seances/create', 'ProgramController@ajxNewProgramSeance')->name('ajxNewProgramSeance')->middleware('checkRoles:Admin,Webmaster');
    Route::get('/programs/{programId}/seances/edit/{seanceId}', 'ProgramController@editprogramSeance')->name('editProgramSeance')->middleware('checkRoles:Admin,Webmaster');
    Route::post('/programs/{programId}/seances/edit/{seanceId}', 'ProgramController@ajxUpdateProgramSeance')->name('ajxUpdateProgramSeance')->middleware('checkRoles:Admin,Webmaster');
    Route::delete('/programs/{programId}/seances/delete/{seanceId}', 'ProgramController@deleteProgramSeance')->name('deleteProgramSeance')->middleware('checkRoles:Admin,Webmaster');

    Route::get('/programs/{programId}/programming', 'ProgramController@programming')->name('programming')->middleware('checkRoles:Admin,Webmaster');
    Route::get('/programs/{programId}/programming/create', 'ProgramController@newProgramming')->name('newProgramming')->middleware('checkRoles:Admin,Webmaster');
    Route::post('/programs/{programId}/programming/create', 'ProgramController@ajxNewProgramming')->name('ajxNewProgramming')->middleware('checkRoles:Admin,Webmaster');
    Route::get('/programs/{programId}/programming/edit/{programmingId}', 'ProgramController@editprogramming')->name('editProgramming')->middleware('checkRoles:Admin,Webmaster');
    Route::post('/programs/{programId}/programming/edit/{programmingId}', 'ProgramController@ajxUpdateProgramming')->name('ajxUpdateProgramming')->middleware('checkRoles:Admin,Webmaster');
    Route::delete('/programs/{programId}/programming/delete/{programmingId}', 'ProgramController@deleteProgramming')->name('deleteProgramming')->middleware('checkRoles:Admin,Webmaster');

    Route::get('/podcasts', 'PodcastController@index')->name('listPodcasts')->middleware('checkRoles:Admin,Webmaster');
    Route::post('/podcasts/create', 'PodcastController@ajxNewPodcast')->name('ajxNewPodcast')->middleware('checkRoles:Admin,Webmaster');
    Route::get('/podcasts/create', 'PodcastController@newPodcast')->name('createPodcast')->middleware('checkRoles:Admin,Webmaster');
    Route::get('/podcasts/edit/{podcastId}', 'PodcastController@editPodcast')->name('editPodcast')->middleware('checkRoles:Admin,Webmaster');
    Route::post('/podcasts/edit/{podcastId}', 'PodcastController@ajxUpdatePodcast')->name('ajxUpdatePodcast')->middleware('checkRoles:Admin,Webmaster');
    Route::delete('/podcasts/delete/{podcastId}', 'PodcastController@deletePodcast')->name('deletePodcast')->middleware('checkRoles:Admin,Webmaster');

    Route::get('/newsletter', 'NewsletterSubscriptionsController@index')->name('newsletter')->middleware('checkRoles:Admin');
    Route::delete('/newsletter/delete/{newsletterSubscriptions}', 'NewsletterSubscriptionsController@destroy')->name('deleteNewsletterSubscription')->middleware('checkRoles:Admin');

    Route::get('/contact/{contact}', 'ContactController@show')->name('contactShow')->middleware('checkRoles:Admin');
    Route::get('/contact', 'ContactController@index')->name('contactsList')->middleware('checkRoles:Admin');

    Route::get('/marchi/categories', 'MarchiController@CategoryList')->name('marchiCategoriesList')->middleware('checkRoles:Admin,ElMarchi');
    Route::get('/marchi/categories/create', 'MarchiController@newCategory')->name('newMarchiCategory')->middleware('checkRoles:Admin,ElMarchi');
    Route::post('/marchi/categories/create', 'MarchiController@ajxNewCategory')->name('ajxNewMarchiCategory')->middleware('checkRoles:Admin,ElMarchi');
    Route::get('/marchi/categories/edit/{category}','MarchiController@editCategory')->name("editMarchiCategory")->middleware('checkRoles:Admin,ElMarchi');
    Route::post('/marchi/categories/edit/{category}', 'MarchiController@ajxUpdateCategory')->name('ajxUpdateMarchiCategory')->middleware('checkRoles:Admin,ElMarchi');
    Route::delete('/marchi/categories/delete/{category}', 'MarchiController@deleteCategory')->name('deleteMarchiCategory')->middleware('checkRoles:Admin,ElMarchi');
    Route::get('/marchi', 'MarchiController@ProductList')->name('marchiProductsList')->middleware('checkRoles:Admin,ElMarchi');
    Route::get('/marchi/products', 'MarchiController@ProductList')->middleware('checkRoles:Admin,ElMarchi');
    Route::get('/marchi/products/create', 'MarchiController@newProduct')->name('newMarchiProduct')->middleware('checkRoles:Admin,ElMarchi');
    Route::post('/marchi/products/create', 'MarchiController@ajxNewProduct')->name('ajxNewMarchiProduct')->middleware('checkRoles:Admin,ElMarchi');
    Route::get('/marchi/products/edit/{product}','MarchiController@editProduct')->name("editMarchiProduct")->middleware('checkRoles:Admin,ElMarchi');
    Route::post('/marchi/products/edit/{product}', 'MarchiController@ajxUpdateProduct')->name('ajxUpdateMarchiProduct')->middleware('checkRoles:Admin,ElMarchi');
    Route::delete('/marchi/products/delete/{product}', 'MarchiController@deleteProduct')->name('deleteMarchiProduct')->middleware('checkRoles:Admin,ElMarchi');
    Route::get('/marchi/days', 'MarchiController@days')->name('marchiDays')->middleware('checkRoles:Admin,ElMarchi');
    Route::get('/marchi/days/create', 'MarchiController@newDay')->name('newMarchiDay')->middleware('checkRoles:Admin,ElMarchi');
    Route::post('/marchi/days/create', 'MarchiController@ajxNewDay')->name('ajxNewMarchiDay')->middleware('checkRoles:Admin,ElMarchi');
    Route::get('/marchi/days/edit/{day}', 'MarchiController@editDay')->name('editMarchiDay')->middleware('checkRoles:Admin,ElMarchi');
    Route::post('/marchi/days/edit/{day}', 'MarchiController@ajxUpdateDay')->name('ajxUpdateMarchiDay')->middleware('checkRoles:Admin,ElMarchi');
    Route::delete('/marchi/days/delete/{day}', 'MarchiController@deleteDay')->name('deleteMarchiday')->middleware('checkRoles:Admin,ElMarchi');

    Route::post('/photomaker/habillage_category', 'PhotoController@categoryHabillage')->name('PhotoCategoryHabillage');
    Route::post('/photomaker/photo_article', 'PhotoController@photoArticle')->name('PhotoArticle');
    Route::post('/photomaker/photo_animator', 'PhotoController@photoAnimator')->name('PhotoAnimator');
    Route::post('/photomaker/photo_program', 'PhotoController@photoProgram')->name('PhotoProgram');
    Route::post('/photomaker/photo_program_live', 'PhotoController@photoProgramLive')->name('PhotoProgramLive');
    Route::post('/photomaker/photo_marchi_category', 'PhotoController@photoMarchiCategory')->name('PhotoMarchiCategory');
    Route::post('/photomaker/photo_marchi_product', 'PhotoController@photoMarchiProduct')->name('PhotoMarchiProduct');
    Route::post('/photomaker/photo_kids', 'PhotoController@photoKids')->name('PhotoKids');

    Route::get('/config','ConfigurationController@index')->name("config")->middleware('checkRoles:Admin');
    Route::get('/config/edit/{alias}','ConfigurationController@edit')->name("editConfig")->middleware('checkRoles:Admin');
    Route::post('/config/edit/{alias}','ConfigurationController@update')->name("ajxUpdateConfig")->middleware('checkRoles:Admin');

    // Diwan Kids
    Route::get('/kids','KidsStoryController@index')->name("kidsStoriesList")->middleware('checkRoles:Admin,Webmaster,DiwanKids');
    Route::get('/kids/create_story', 'KidsStoryController@newStory')->name('newStory')->middleware('checkRoles:Admin,Webmaster,DiwanKids');
    Route::post('/kids/create_story', 'KidsStoryController@ajxNewStory')->name('ajxNewStory')->middleware('checkRoles:Admin,Webmaster,DiwanKids');
    Route::get('/kids/edit/{storyId}', 'KidsStoryController@editStory')->name('editStory')->middleware('checkRoles:Admin,Webmaster,DiwanKids');
    Route::post('/kids/edit/{storyId}', 'KidsStoryController@ajxUpdateStory')->name('ajxUpdateStory')->middleware('checkRoles:Admin,Webmaster,DiwanKids');
    Route::delete('/kids/delete/{storyId}', 'KidsStoryController@deleteStory')->name('deleteStory')->middleware('checkRoles:Admin,Webmaster,DiwanKids');
    // Pub
    Route::get('/ads','AdsController@index')->name("AdsList")->middleware('checkRoles:Admin');
    Route::get('/ads/edit/{adsId}', 'AdsController@editAds')->name('editAds')->middleware('checkRoles:Admin');
    Route::post('/ads/edit/{adsId}', 'AdsController@ajxUpdateAds')->name('ajxUpdateAds')->middleware('checkRoles:Admin');
    //Sitemap
    Route::get('/sitemapindex.xml','SitemapController@SitemapIndex')->name("SitemapIndex");
    Route::get('/sitemap-{id}.xml','SitemapController@index')->name("Sitemap");

    Route::get("/logout",'Auth\LoginController@logout')->name("logout");

    //migrator
    Route::get("/migrator",'MigratorController@index')->name("migrator");
    Route::get("/migrator/get-users",'MigratorController@getUsers')->name("migratorUsers");
    Route::get("/migrator/get-categories",'MigratorController@getCategories')->name("migratorCategories");
    Route::get("/migrator/get-animators",'MigratorController@getAnimators')->name("migratorAnimators");
    Route::get("/migrator/get-programs",'MigratorController@getPrograms')->name("migratorPrograms");
    Route::post("/migrator/save-program",'MigratorController@saveProgram')->name("migratorSaveProgram");
    Route::get("/migrator/get-programs-seances",'MigratorController@getProgramsSeances')->name("migratorProgramsSeances");
    Route::post("/migrator/save-program-seance",'MigratorController@saveProgramSeance')->name("migratorSaveProgramSeance");
    Route::get("/migrator/get-podcasts",'MigratorController@getPodcasts')->name("migratorPodcasts");
    Route::post("/migrator/save-podcast",'MigratorController@savePodcast')->name("migratorSavePodcast");
    Route::get("/migrator/get-posts",'MigratorController@getPosts')->name("migratorPosts");
    Route::post("/migrator/save-post",'MigratorController@savePost')->name("migratorSavePost");
    Route::get("/post-migrator",'PostsMigratorController@index')->name("migratorPostMigrator");
    Route::get("/post-migrator-import",'PostsMigratorController@getPosts')->name("migratorPostMigratorImport");
    Route::get("/kids-migrator",'KidsMigratorController@index')->name("migratorKids");
    Route::get("/kids-migrator/get-categories",'KidsMigratorController@getCategories')->name("migratorKidsCategories");
    Route::get("/kids-migrator/get-stories",'KidsMigratorController@getStories')->name("migratorKidsStories");
    Route::post("/kids-migrator/save-story",'KidsMigratorController@saveStory')->name("migratorSaveStory");

    Route::get("/marchi-migrator",'MarchiMigratorController@index')->name("marchiMigrator");
    Route::get("/migrator/get-marchi-categories",'MarchiMigratorController@getMarchiCategories')->name("marchiCategoriesMigrator");
    Route::get("/migrator/get-marchi-products",'MarchiMigratorController@getMarchiProducts')->name("marchiGetProductsMigrator");
    Route::post("/migrator/save-marchi-products",'MarchiMigratorController@saveMarchiProducts')->name("marchiSaveProductsMigrator");
    Route::get("/migrator/get-marchi-prices",'MarchiMigratorController@getMarchiPrices')->name("marchiGetPricesMigrator");
    Route::post("/migrator/save-marchi-prices",'MarchiMigratorController@saveMarchiPrices')->name("marchiSavePricesMigrator");

    //register and password recovery desable
    Route::any("/register",'NotFoundController@index')->name("register");
    Route::any("password/reset",'NotFoundController@index')->name("resetPassword");
    Route::any("password/email",'NotFoundController@index')->name("resetPasswordEmail");
    Route::any("password/reset/{token}",'NotFoundController@index')->name("resetPasswordToken");

    //search and plugins
    Route::get('/posts/search','PostController@searchArticle')->name("searchArticle")->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/videos/search','PostController@searchVideo')->name("searchVideo")->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/gallery/search','PostController@searchGallerie')->name("searchGallerie")->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/posts/autocomp','PostController@ajxPostLink')->name("ajxPostLink")->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');

    Route::get('/posts/autocomp','PostController@ajxPostLink')->name("ajxPostLink")->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');

    Route::get('/videos/notify/{id}/{type}', 'PostController@notify')->name('notifyPost')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/notify/notify','NotifyController@index')->name("notify")->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::post('/notify/sendNotification','NotifyController@sendNotification')->name("sendNotification")->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::post('/notify/photoNotify','PhotoController@photoNotify')->name("PhotoNotify")->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');

    Route::get('/surveys_list','SurveyController@index')->name("surveysList")->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/surveys/search','SurveyController@searchSurvey')->name("searchSurvey")->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::post('/surveys/desactive', 'SurveyController@desactivate')->name('surveyDesactivate')->middleware('checkRoles:Admin');
    Route::post('/surveys/activate', 'SurveyController@activate')->name('surveyActivate')->middleware('checkRoles:Admin');
    Route::delete('/surveys/delete/{surveyId}', 'SurveyController@deleteSurvey')->name('deleteSurvey')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/surveys/creates', 'SurveyController@newSurvey')->name('newSurvey')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::post('/surveys/create', 'SurveyController@ajxNewSurvey')->name('ajxNewSurvey')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::get('/surveys/edit/{surveyId}', 'SurveyController@editSurvey')->name('editSurvey')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');
    Route::post('/surveys/edit/{surveyId}', 'SurveyController@ajxUpdateSurvey')->name('ajxUpdateSurvey')->middleware('checkRoles:Admin,Webmaster,JournalisteWeb,Journaliste');

// });

Route::get('/استطلاعات-الرأي/{surveyId}','SurveyController@show')->name('show');


Auth::routes();
