@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route("usersList") }}">Utilisateurs</a>
</li>
<li class="breadcrumb-item active">
    Changer mot de passe utilisateur ({{ $user->name}})
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajxUpdateUserPassword',['userId'=>$user->id]) }}" method="post" id="editPasswordForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        {!! trans("diwan.Edit password") !!}
                    </div>

                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="password">Mot de passe</label>
                                    <input class="form-control" type="password" name="password" id="password" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="conf_password">Confirmer mot de passe</label>
                                    <input class="form-control" type="password" name="conf_password" id="conf_password" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/users/editPassword.js') }}"></script>
@endsection
