@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route("usersList") }}">Utilisateurs</a>
</li>
<li class="breadcrumb-item active">
    Editer Utilisateur ({{ $user->name }})
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('editUser',['userId'=>$user->id]) }}" method="post" id="editForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        {!! trans("diwan.Edit user") !!}
                    </div>

                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="email">Email</label>
                                    <input class="form-control" type="email" name="email" value="{{ $user->email }}" id="email" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="name">Nom & Prénom</label>
                                    <input class="form-control" type="text" name="name" value="{{ $user->name }}" id="name" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>
                        
                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">Roles</label>
                            <div class="col-md-9 col-form-label">
                                @foreach($roles as $role)
                                    <div class="form-check checkbox">
                                        <input class="form-check-input" name="roles[]" type="checkbox" id="role-{{$role->id}}" value="{{ $role->id }}" @if($user->hasRole($role->name)) checked @endif >
                                        <label class="form-check-label" for="role-{{$role->id}}">{{$role->name}}</label>
                                    </div>
                                @endforeach
                            </div>
                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/users/edit.js') }}"></script>
@endsection
