@extends('dwtemplate.index')

@section("breadcrumb")
    <li class="breadcrumb-item active">Tags Predefinis</li>
@endsection()

@section("pageTopMenu")
    <a class="btn" href="{{ route('tags.create') }}"> Create New Tags</a>
@endsection

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Liste des Tags Predefinis
                    </div>
                    <div class="card-body">


                        @if ($message = Session::get('success'))
                            <div class="alert alert-success">
                                <p>{{ $message }}</p>
                            </div>
                        @endif
                        <table class="table table-responsive-sm table-striped">
                            <thead>
                            <tr>
                                <td>No</td>
                                <td>Name</td>
                                <td>Action</td>
                            </tr>
                            </thead>

                            <tbody>
                            @foreach ($tags as $tag)
                                <tr>
                                    <td>{{ ++$i }}</td>
                                    <td>{{ $tag->name }}</td>
                                    <td>
                                        <form action="{{ route('tags.destroy',$tag->id) }}" method="POST">

                                            <a class="btn btn-sm btn-primary" href="{{ route('tags.edit',$tag->id) }}">Edit</a>

                                            @csrf
                                            @method('DELETE')

                                            <button type="submit" class="btn btn-sm btn-warning">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </table>
                        {!! $tags->links() !!}
                </div>
            </div>
        </div>
    </div>
@endsection

