@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">Sondages</li>
@endsection()

@section("pageTopMenu")
    <a class="btn" href="{{ route('newSurvey') }}">+ Ajouter sondage</a>
@endsection

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des sondages
                    <div class="col-sm-4 pull-right">
                        <form class="form-horizontal" id="search_survey" action="{{ route('searchSurvey') }}" method="get">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group">
                                        <input class="form-control" type="text" value="{{ $title?? '' }}" name="search_survey_title" placeholder="Titre" required>
                                        <span class="input-group-append">
                                            <button class="btn btn-primary" type="submit">
                                            <i class="fa fa-search"></i> Recherche</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card-body">


                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>Date</td>
                                <td>Titre</td>
                                <td>Date de debut</td>
                                <td>Date de fin</td>
                                <td>Activé</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($surveys as $survey)
                                <tr>
                                    <td>{{ $survey->created_at->format("d/m/Y") }}</td>
                                    <td>{{ $survey->name }}</td>
                                    <td>{{ $survey->startDate }}</td>
                                    <td>{{ $survey->endDate }}</td>
                                    <td>
                                        <label class="switch switch-label switch-success">
                                        <input
                                            class="switch-input survey-switch-input"
                                            type="checkbox"
                                            @if($survey->status==1) checked @endif
                                            data-id="{{ $survey->id }}"
                                            data-desactivate-route="{{ route('surveyDesactivate') }}"
                                            data-activate-route="{{ route('surveyActivate') }}"
                                            data-token="{{ csrf_token() }}"
                                        >
                                            <span class="switch-slider" data-checked="On" data-unchecked="Off"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <a href="{{ route('editSurvey',['surveyId'=>$survey->id]) }}" class="btn btn-sm btn-primary">Editer</a>
                                        @if((Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster") || Auth::user()->hasRole("JournalisteWeb")) || $survey->status!=1)
                                            <a href="{{ route('deleteSurvey',['surveyId'=>$survey->id]) }}" class="btn btn-sm btn-warning deleteSurvey">Supprimer</a>
                                        @endif
                                        <a href="http://localhost:8001/استطلاعات-الرأي/{{ $survey->id }}" target="_blank" class="btn btn-sm btn-info">Preview</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>

                    {{$surveys->onEachSide(5)->links()}}
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/surveys/list.js') }}"></script>
    <script src="{{ asset('js/scripts/surveys/delete-survey.js') }}"></script>
@endsection
