@extends('dwtemplate.index')

@php
    $answersSurvey = [
        [
            'name' => '',
        ]
    ];
@endphp

@section('breadcrumb')
    <li class="breadcrumb-item ">
        <a href="{{ route('postsList') }}">Liste des sondages</a>
    </li>
    <li class="breadcrumb-item active">
        Nouveau sondage
    </li>
@endsection

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <form action="{{ route('ajxNewSurvey') }}" method="post" id="createForm">
                    {!! csrf_field() !!}
                    <div class="card">
                        <div class="card-header">
                            <i class="fa fa-align-justify"></i>
                            Nouveau sondage
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-col-form-label" for="title">Titre</label>
                                        <input class="form-control" type="text" name="name" id="title" />
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-col-form-label" for="start_date">Date de début</label>
                                        <input class="form-control" type="text" value="<?php echo (new \DateTime())->format('d-m-Y'); ?>"
                                            id="startDate" name="startDate">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-col-form-label" for="end_date">Date de fin</label>
                                        <input class="form-control" type="text" value="<?php echo (new \DateTime())->format('d-m-Y'); ?>"
                                            id="endDate" name="endDate">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <div style="display: flex;align-items: baseline;justify-content: space-between;">
                                            <label class="form-col-form-label">Réponses sondage </label>
                                            <button style="margin-left: 1%;" class="btn btn-primary mt-3" type="button"
                                                id="addAnswer"><i class="icon fas fa-plus"> Ajouter une
                                                    ligne</i></button>
                                        </div>
                                        <div id="answersSurvey">
                                            <table class="table">
                                                <thead>
                                                    <tr>
                                                        <th style="text-align: center" class="col-md-10">Contenu</th>
                                                        <th style="text-align: center" class="col-md-2">Suppression</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($answersSurvey as $key => $answer)
                                                        <tr data-answer-index="{{ $key }}">
                                                            <td class="col-md-10">
                                                                <input style="text-align: center" type="text"
                                                                    class="form-control" name="answers[0]" />
                                                            </td>
                                                            <td style="text-align: center" class="col-md-2">
                                                                <button type="button" class="btn btn-danger delete-answer"
                                                                    data-toggle="modal" data-target="#deleteModal">
                                                                    <i class="fas fa-trash-alt"></i>
                                                                </button>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                        </div>
                    </div>
                </form>
                <!-- Modal -->
                <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Confirmation de suppression
                                </h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                Êtes-vous sûr de vouloir supprimer cette ligne ?
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                                <button type="button" class="btn btn-danger" id="confirmDelete">Supprimer</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/surveys/create-survey.js') }}"></script>
@endsection

<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        function reassignIndices() {
            $('#answersSurvey tbody tr').each(function(index) {
                $(this).find('input').attr('name', `answers[${index}]`);
            });
        }
        $('#answersSurvey').on('click', '.delete-answer', function() {
            const answerToDelete = $(this).closest('tr');
            $('#deleteModal').modal('show');
            $('#confirmDelete').click(function() {
                answerToDelete.remove();
                reassignIndices();
                $('#deleteModal').modal('hide');
            });
        });
        $('#addAnswer').click(function() {
            const newAnswer = `<tr>
            <td class="col-md-10"><input style="text-align: center" type="text" class="form-control" name="answers[${$('#answersSurvey tbody tr').length}]"/></td>
            <td style="text-align: center" class="col-md-2"><button type="button" class="btn btn-danger delete-answer" data-toggle="modal" data-target="#deleteModal"><i class="fas fa-trash-alt"></i></button></td>
        </tr>`;
            $('#answersSurvey tbody').append(newAnswer);
            reassignIndices();
        });
        // datepicker
        $("#startDate").datepicker({
            changeMonth: true,
            changeYear: true,
            showButtonPanel: true,
            dateFormat: 'dd-mm-yy',
        });
        $("#endDate").datepicker({
            changeMonth: true,
            changeYear: true,
            showButtonPanel: true,
            dateFormat: 'dd-mm-yy',
        });
    });
</script>
