@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">Statistiques</li>
@endsection()

@section("pageTopMenu")
    <a class="btn" href="{{ route('newArticle') }}">+ Ajouter article</a>
@endsection

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Statistiques des rédacteurs
                    <div class="col-sm-8 pull-right">
                        <form class="form-horizontal" id="search_post" action="{{ route('statFilter') }}" method="post">
                            <div class="row">
                                    <div class="input-group col-md-8">
                                        {{-- <input class="form-control" type="text" value="{{ $title?? '' }}" name="search_post_title" placeholder="Titre" required>
                                        <span class="input-group-append">
                                            <button class="btn btn-primary" type="submit">
                                            <i class="fa fa-search"></i> Recherche</button>
                                        </span> --}}
                                        <input class="form-control" type="text" value="<?php echo (new \DateTime())->format('m-Y'); ?>" id="datepicker" name="datepicker" placeholder="Titre" required>
                                    </div>
                                    <div class="input-group col-md-4">
                                        <button class="btn btn-primary" type="submit">
                                            <i class="fa fa-search"></i> Filtrer</button>
                                    </div>

                            </div>
                        </form>
                    </div>
                </div>

                <div class="card-body">

                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>Auteur</td>
                                @foreach ($array_categories as $item)
                                    <td>{{$item->title}}</td>
                                @endforeach
                                <td>Total</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($users as $item)
                            <?php $total =0 ?>
                            <tr>
                                <td>{{ $item->name }}</td>
                                @foreach ($array_categories as $categ)
                                <?php $name = $categ->title;
                                    if (isset($item->counter[$categ->id])) {
                                        $total += $item->counter[$categ->id];
                                         ?>
                                        <td>{{$item->counter[$categ->id]}}</td>
                                <?php     }else { ?>
                                        <td>0</td>
                                <?php     }
                                ?>
                                @endforeach
                                <td>{{ $item->total }}</td>
                            </tr>
                            @endforeach
                            <tr>
                                <td>Total</td>
                                @foreach ($array_categories as $cat)
                                    <td>{{$cat->total}}</td>
                                @endforeach
                            <td>{{ $total_categorie }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
  $("#datepicker").datepicker( {
    changeMonth: true,
            changeYear: true,
            showButtonPanel: true,
            dateFormat: 'mm-yy',
            onClose: function(dateText, inst) {
                $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
            }
});
</script>
@endsection
