@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">Internautes</li>
@endsection()

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des internautes
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Nom & Prénom</td>
                                <td>Email</td>
                                <td>Date d'inscription</td>
                                <td>Id Google</td>
                                <td>Id Facebook</td>
                                <td>Activé</td>
                                <!-- <td>Actions</td> -->
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($users as $user)
                                <tr>
                                    <td>{{ $user->id }}</td>
                                    <td>{{ $user->name }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td>{{ $user->created_at }}</td>
                                    <td>{{ $user->google_id }}</td>
                                    <td>{{ $user->facebook_id }}</td>
                                    <td>
                                        <label class="switch switch-label switch-success">
                                        <input
                                            class="switch-input user-switch-input"
                                            type="checkbox"
                                            @if($user->status==1) checked @endif
                                            data-id="{{ $user->id }}"
                                            data-desactivate-route="{{ route('socialUserDesactivate') }}"
                                            data-activate-route="{{ route('socialUserActivate') }}"
                                            data-token="{{ csrf_token() }}"
                                        >
                                            <span class="switch-slider" data-checked="On" data-unchecked="Off"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <!-- <a href="{{ route('editUser',['userId'=>$user->id]) }}" class="btn btn-sm btn-primary">Editer</a> -->
                                        <!-- <a href="{{ route('editUserPassword',['userId'=>$user->id]) }}" class="btn btn-sm btn-warning">Changer mot de passe</a> -->
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/social-users/list.js') }}"></script>
@endsection
