@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">Emissions</li>
@endsection()

@section("pageTopMenu")
    <a class="btn" href="{{ route('newProgram') }}">+ Ajouter Emission</a>
@endsection

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des émissions
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Titre</td>
                                <td>Animateur</td>
                                <td>Status</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($programs as $program)
                                <tr>
                                    <td>{{ $program->id }}</td>
                                    <td>{{ $program->title }}</td>
                                    <td>
                                        @foreach($program->animators as $animator)
                                            <span class="badge badge-primary">{{ $animator->name }}</span>
                                        @endforeach
                                    </td>
                                    <td>
                                        @if($program->status==0)
                                            Désactivé
                                        @elseif($program->status==1)
                                            Publié
                                        @else
                                            Archive
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('editProgram',['programId'=>$program->id]) }}" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="{{ route('deleteProgram',['programId'=>$program->id]) }}" class="btn btn-sm btn-warning deleteProgram">Supprimer</a>
                                        <a href="{{ route('programSeances',['programId'=>$program->id]) }}" class="btn btn-sm btn-info">Seances</a>
                                        <a href="{{ route('programming',['programId'=>$program->id]) }}" class="btn btn-sm btn-success">Programmation</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>

                    {{ $programs->onEachSide(5)->links() }}
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/programs/delete.js') }}"></script>
@endsection
