@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route('programsList') }}">Liste des emissions</a>
</li>
<li class="breadcrumb-item active">
    Liste des séances ({{ $program->title }})
</li>
@endsection

@section("pageTopMenu")
    <a class="btn" href="{{ route('createProgramSeance',['programId'=>$program->id]) }}">+ Ajouter seance</a>
@endsection

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des séances
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Titre</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($seances as $seance)
                                <tr>
                                    <td>{{ $seance->id }}</td>
                                    <td>{{ $seance->title }}</td>
                                    <td>
                                        <a href="{{ route('editProgramSeance',['programId'=>$program->id,'seanceId'=>$seance->id]) }}" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="{{ route('deleteProgramSeance',['programId'=>$program->id,'seanceId'=>$seance->id]) }}" class="btn btn-sm btn-warning deleteProgramSeance">Supprimer</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>

                    {{ $seances->onEachSide(5)->links() }}
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/programs/delete-seance.js') }}"></script>
@endsection
