@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route('programsList') }}">Liste des emissions</a>
</li>
<li class="breadcrumb-item active">
    Programmations ({{ $program->title }})
</li>
@endsection

@section("pageTopMenu")
    <a class="btn" href="{{ route('newProgramming',['programId'=>$program->id]) }}">+ Ajouter programmation</a>
@endsection

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Programmation
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>Jour</td>
                                <td>Heure Début</td>
                                <td>Heure Fin</td>
                                <td>OnAir</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($programmings as $programming)
                                <tr>
                                    <td>{!! trans('days.'.$programming->day) !!}</td>
                                    <td>{{ $programming->start_time }}</td>
                                    <td>{{ $programming->end_time }}</td>
                                    <td>
                                        @if($programming->onair) Oui @else Non @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('editProgramming',['programId'=>$program->id,'programmingId'=>$programming->id]) }}" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="{{ route('deleteProgramming',['programId'=>$program->id,'programmingId'=>$programming->id]) }}" class="btn btn-sm btn-warning deleteProgramming">Supprimer</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/programs/delete-programming.js') }}"></script>
@endsection
