@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route('programsList') }}">Liste des emissions</a>
</li>
<li class="breadcrumb-item active">
    Editer émission ({{ $program->title }})
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajxUpdateProgram',['programId'=>$program->id]) }}" method="post" id="editForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Nouvelle émission
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="text" value="{{ $program->title }}" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_title">Titre SEO *</label>
                                    <input class="form-control" type="text" value="{{ $program->meta_title }}" name="meta_title" id="meta_title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="animators">Animateurs</label>
                                    <select class="form-control" id='animators' name='animators[]' multiple="multiple">
                                        @foreach($animators as $animator)
                                            <option value="{{ $animator->id }}" @if($program->animators->find($animator->id)) selected="selected" @endif>{{ $animator->name }}</option>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_keywords">Mots Clés *</label>
                                    <input class="form-control" type="text" value="{{ $program->meta_keywords }}" name="meta_keywords" id="meta_keywords" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="summary">Déscription *</label>
                                    <textarea class="form-control" id="summary" name="summary">{{ $program->summary }}</textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_description">Déscription SEO *</label>
                                    <textarea class="form-control" id="meta_description" name="meta_description">{{ $program->meta_description }}</textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="content">Contenu</label>
                                    <textarea class="form-control" id="content" name="content">{{ $program->content }}</textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_maker">Image *</label>
                                    
                                    <div class="input-group">
                                        <input type="text" value="{{ $program->img }}" class="form-control imgSelector" data-photoMaker="{{ route('PhotoProgram') }}" data-original="{{ $program->img }}" disabled name="program_img_maker" data-dest="img" id="program_img_maker" />
                                        <span class="input-group-append">
                                            <button class="btn btn-primary popup_selector" data-inputid="program_img_maker" type="button">
                                                <i class="fa fa-photo"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-warning popup_selector_colse" data-inputid="program_img_maker" type="button">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-success popup_selector_visualize" href="{{ config("paths.PHOTOS_URL").'programs/'.$program->img }}" data-inputid="program_img_maker" type="button">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </span>
                                    </div>
                                    <input type="hidden" value="{{ $program->img }}" class="form-control" name="img" id="img" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_alt">Alt image*</label>
                                    <input class="form-control" value="{{ $program->img_alt }}" type="text" name="img_alt" id="img_alt" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="hashtag">Hashtag*</label>
                                    <input class="form-control" type="text" value="{{ $program->img_alt }}" name="hashtag" id="hashtag" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="status">Statut</label>
                                    <select class="form-control" id='status' name='status'>
                                        <option value="0" @if($program->status==0) selected="selected" @endif>Désactivé</option>
                                        <option value="1" @if($program->status==1) selected="selected" @endif>Publié</option>
                                        <option value="2" @if($program->status==2) selected="selected" @endif>Archivé</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script>
        var elfinderUrl='{{ url("/elfinder/popup") }}/';
        var storagePath='{{ config("paths.STORAGE_PATH") }}';
        var photosUrl='{{ config("paths.PHOTOS_URL") }}';
    </script>
    <link rel="stylesheet" type="text/css" href="{{ asset( 'vendor/colorbox/css/colorbox.css') }}">
    <script src="{{ asset('vendor/colorbox/js/jquery.colorbox-min.js') }}"></script>
    <script src="{{ asset('packages/barryvdh/elfinder/js/standalonepopup.js') }}"></script>
    
    <script src="{{ asset('js/scripts/programs/edit.js') }}"></script>

    <script>
        $(document).ready(function() {
            $('#animators').select2();
        });
    </script>
@endsection
