@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route('programsList') }}">Liste des emissions</a>
</li>
<li class="breadcrumb-item ">
    <a href="{{ route('programming',['programId'=>$programming->program->id]) }}">Programmation ({{ $programming->program->title }}) </a>
</li>
<li class="breadcrumb-item active">
    Editer programmation
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajxUpdateProgramming',['programId'=>$programming->program->id,'programmingId'=>$programming->id]) }}" method="post" id="editForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer programmation
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="day">Jour *</label>
                                    <select class="form-control" name="day" id="day">
                                        <option value="1" @if($programming->day==1) selected="selected" @endif >{!! trans('days.1') !!}</option>
                                        <option value="2" @if($programming->day==2) selected="selected" @endif >{!! trans('days.2') !!}</option>
                                        <option value="3" @if($programming->day==3) selected="selected" @endif >{!! trans('days.3') !!}</option>
                                        <option value="4" @if($programming->day==4) selected="selected" @endif >{!! trans('days.4') !!}</option>
                                        <option value="5" @if($programming->day==5) selected="selected" @endif >{!! trans('days.5') !!}</option>
                                        <option value="6" @if($programming->day==6) selected="selected" @endif >{!! trans('days.6') !!}</option>
                                        <option value="7" @if($programming->day==7) selected="selected" @endif >{!! trans('days.7') !!}</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="start_time">Heure Début *</label>
                                    <input class="form-control" value="{{ $programming->start_time }}" type="text" name="start_time" id="start_time" />
                                    
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="end_time">Heure Fin *</label>
                                    <input class="form-control" value="{{ $programming->end_time }}" type="text" name="end_time" id="end_time" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" id="onair" name="onair" @if($programming->onair) checked="checked" @endif type="checkbox" value="1">
                                        <label class="form-check-label" for="onair">OnAir</label>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')

    <script src="{{ asset('js/scripts/programs/edit-programming.js') }}"></script>

    <script>
        $(document).ready(function(){
            $("#start_time").datetimepicker({
                format:"HH:mm:ss"
            });
            $("#end_time").datetimepicker({
                format:"HH:mm:ss"
            });
        });
    </script>
@endsection
