@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route('programsList') }}">Liste des emissions</a>
</li>
<li class="breadcrumb-item ">
    <a href="{{ route('programming',['programId'=>$program->id]) }}">Programmation ({{ $program->title }}) </a>
</li>
<li class="breadcrumb-item active">
    Nouvelle programmation
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajxNewProgramming',['programId'=>$program->id]) }}" method="post" id="createForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Nouvelle programmation
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="day">Jour *</label>
                                    <select class="form-control" name="day" id="day">
                                        <option value="1">{!! trans('days.1') !!}</option>
                                        <option value="2">{!! trans('days.2') !!}</option>
                                        <option value="3">{!! trans('days.3') !!}</option>
                                        <option value="4">{!! trans('days.4') !!}</option>
                                        <option value="5">{!! trans('days.5') !!}</option>
                                        <option value="6">{!! trans('days.6') !!}</option>
                                        <option value="7">{!! trans('days.7') !!}</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="start_time">Heure Début *</label>
                                    <input class="form-control" type="text" name="start_time" id="start_time" />
                                    
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="end_time">Heure Fin *</label>
                                    <input class="form-control" type="text" name="end_time" id="end_time" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" id="onair" name="onair" type="checkbox" value="1">
                                        <label class="form-check-label" for="onair">OnAir</label>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')

    <script src="{{ asset('js/scripts/programs/create-programming.js') }}"></script>

    <script>
        $(document).ready(function(){
            $("#start_time").datetimepicker({
                format:"HH:mm:ss"
            });
            $("#end_time").datetimepicker({
                format:"HH:mm:ss"
            });
        });
    </script>
@endsection
