@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">Articles</li>
@endsection()

@section("pageTopMenu")
    <a class="btn" href="{{ route('newArticle') }}">+ Ajouter article</a>
@endsection

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des articles
                    <div class="col-sm-4 pull-right">
                        <form class="form-horizontal" id="search_post" action="{{ route('searchArticle') }}" method="get">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group">
                                        <input class="form-control" type="text" value="{{ $title?? '' }}" name="search_post_title" placeholder="Titre" required>
                                        <span class="input-group-append">
                                            <button class="btn btn-primary" type="submit">
                                            <i class="fa fa-search"></i> Recherche</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card-body">


                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>Date</td>
                                <td>Titre</td>
                                <td>Catégories</td>
                                <td>Tags</td>
                                <td>Auteur</td>
                                <td>Etat</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($posts as $article)
                                <tr>
                                    <td>{{ $article->created_at->format("d/m/Y") }}</td>
                                    <td>{{ $article->title }}</td>
                                    <td>
                                        @foreach($article->categories as $category)
                                            <span class="badge badge-success">{{ $category->title }}</span>
                                        @endforeach
                                    </td>
                                    <td>
                                        @foreach($article->tags as $tag)
                                            <span class="badge badge-success">{{ $tag->title }}</span>
                                        @endforeach
                                    </td>
                                    <td>{{ $article->user->name }}</td>
                                    <td>
                                        @if($article->status==0)
                                            Brouillon
                                        @elseif($article->status==1)
                                            En attente de publication
                                        @elseif($article->status==2)
                                            Publié
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('editArticle',['postId'=>$article->id]) }}" class="btn btn-sm btn-primary">Editer</a>
                                        @if((Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster") || Auth::user()->hasRole("JournalisteWeb")) || $article->status!=2)
                                            <a href="{{ route('deleteArticle',['postId'=>$article->id]) }}" class="btn btn-sm btn-warning deletePost">Supprimer</a>
                                        @endif

                                    <a href="http://www.diwanfm.net/news/preview/{{$article->categories->first()->url_rewrite}}/{{$article->url_rewrite}}" target="_blank" class="btn btn-sm btn-info">Preview</a>
                                    <a href="{{ route('notifyPost',['id'=>$article->id, 'type'=>'article']) }}" class="btn btn-sm btn-info notifyPost">Notifier</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>

                    {{$posts->onEachSide(5)->links()}}
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/posts/delete-article.js') }}"></script>
    <script src="{{ asset('js/scripts/posts/notify.js') }}"></script>
@endsection
