@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route('postsList') }}">Liste des videos</a>
</li>
<li class="breadcrumb-item active">
    Editere video ({{$post->title}})
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajxUpdateVideo',['postId'=>$post->id]) }}" method="post" id="editForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer video
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="title" value="{{ $post->title }}" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title_flash">Titre flash</label>
                                    <input class="form-control" type="text" value="{{ $post->title_flash }}" name="title_flash" id="title_flash" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_title">Titre SEO *</label>
                                    <input class="form-control" type="text" value="{{ $post->meta_title }}" name="meta_title" id="meta_title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="category">Catégories</label>
                                    <select class="form-control" id='category' name='category[]' multiple="multiple">
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}" @if($post->categories->find($category->id)) selected="selected" @endif >{{ $category->title }}</option>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-5">
                                    <div class="form-group">
                                        <label class="form-col-form-label" for="tags">Tags</label>
                                        <select class="form-control" id='tags' name='tags[]' multiple="multiple">
                                            @foreach($post->tags as $tag)
                                                <option value="{{ $tag->id }}" @if($post->tags->find($tag->id)) selected="selected" @endif>{{ $tag->title }}</option>
                                            @endforeach
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="tagss">Tags Predefinis</label>
                                    <select class="form-control tags-predefinis" id='tagss' name='tagss[]'>
                                        @foreach($tagsPredefinis as $tags)
                                            <option value="{{ $tags->id }}" >{{ $tags->name }}</option>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="summary">Résumé *</label>
                                    <textarea class="form-control" id="summary" name="summary">{{ $post->summary }}</textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_description">Déscription SEO *</label>
                                    <textarea class="form-control" id="meta_description" name="meta_description">{{ $post->meta_description }}</textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_keywords">Mots Clés *</label>
                                    <input class="form-control" type="text" name="meta_keywords" value="{{ $post->meta_keywords }}" id="meta_keywords" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_news_keywords">Mots Clés News *</label>
                                    <input class="form-control" type="text" name="meta_news_keywords" value="{{ $post->meta_news_keywords }}" id="meta_news_keywords" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">

                                <div class="form-group">
                                    <input type="hidden" class="form-control" name="img" id="img" value="{{ $post->img }}" />
                                    <label class="form-col-form-label" for="img_maker">Image de couverture *</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control imgSelector" value="{{ $post->img }}" data-photoMaker="{{ route('PhotoArticle') }}" data-original="{{ $post->img }}" disabled name="img_maker" data-dest="img" id="img_maker" />
                                        <span class="input-group-append">
                                            <button class="btn btn-primary popup_selector" data-inputid="img_maker" type="button">
                                                <i class="fa fa-photo"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-warning popup_selector_colse" data-inputid="img_maker" type="button">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-success popup_selector_visualize" href="{{ config("paths.PHOTOS_URL").'posts/'.$post->img }}" data-inputid="img_maker" type="button">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </span>
                                    </div>

                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_alt">Alt image de couverture *</label>
                                    <input class="form-control" type="text" value="{{ $post->img_alt }}" name="img_alt" id="img_alt" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" id="flash_news" @if($post->flash_news==1) checked @endif name="flash_news" type="checkbox" value="1">
                                        <label class="form-check-label" for="flash_news">Flash news</label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" id="facebook_instant_article" name="facebook_instant_article" type="checkbox" value="1" @if($post->facebook_instant_article==1) checked @endif>
                                        <label class="form-check-label" for="facebook_instant_article">Facebook instant video</label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" id="google_amp" name="google_amp" type="checkbox" value="1" @if($post->google_amp==1) checked @endif>
                                        <label class="form-check-label" for="google_amp">Google AMP</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" id="private_post" name="private_post" type="checkbox" value="1" @if($post->is_restricted==1) checked @endif>
                                        <label class="form-check-label" for="private_post">Contenu privé</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="facebook_embed" >Facebook Embed</label>
                                    <textarea class="form-control" id="facebook_embed" name="facebook_embed" id="facebook_embed" >@if($post->video_source==1){{ $post->video_url }}@endif</textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="youtube_url">Lien Youtube</label>
                                    <input type="text" id="youtube_url" name="youtube_url" class="form-control" value="@if($post->video_source==0){{ $post->video_url }}@endif" id="youtube_url" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="content">Contenu *</label>
                                    <textarea class="form-control" id="content" name="content">{{ $post->content }}</textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>


                            @if(!($post->status==2 && !Auth::user()->hasRole("Admin")))
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="form-col-form-label" for="status">Status</label>
                                        <select class="form-control" id='status' name='status'>
                                            <option value='0' @if($post->status==0) selected="selected" @endif >Brouillon</option>
                                            <option value='1' @if($post->status==1) selected="selected" @endif >En attente de publication</option>
                                            @if(Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster") || Auth::user()->hasRole("JournalisteWeb"))
                                                <option value='2' @if($post->status==2) selected="selected" @endif >Publié</option>
                                            @endif
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                            @endif

                        </div>

                    </div>

                    <div class="card-footer">
                        @if((Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster") || Auth::user()->hasRole("JournalisteWeb")) || $post->status!=2)
                            <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                        @endif
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script>
        var elfinderUrl='{{ url("/elfinder/popup") }}/';
        var storagePath='{{ config("paths.STORAGE_PATH") }}';
        var photosUrl='{{ config("paths.PHOTOS_URL") }}';
    </script>
    <link rel="stylesheet" type="text/css" href="{{ asset( 'vendor/colorbox/css/colorbox.css') }}">
    <script src="{{ asset('vendor/colorbox/js/jquery.colorbox-min.js') }}"></script>
    <script src="{{ asset('packages/barryvdh/elfinder/js/standalonepopup.js') }}"></script>

    <script src="{{ asset('js/scripts/posts/edit-article.js') }}"></script>
    <script>
 $(document).ready(function() {
            $('#category').select2();
            $('#tags').select2({
                tags: "true",
                ajax:{
                    url:"{{ route('tagsAjaxList') }}",
                    type:'get',
                    delay: 250,
                    data: function (params) {
                        var query = {
                            term: params.term
                        }
                        return query;
                    },
                    processResults: function (response){
                        return {
                            results:response
                        }
                    }
                },
                minimumInputLength:2
            });
        });
        CKEDITOR.replace( 'content',CKoptions );
        for (var i in CKEDITOR.instances) {
            CKEDITOR.instances[i].on('change', function() { CKEDITOR.instances[i].updateElement() });
        }
    </script>


    <script>
        $(document).ready(function(){
            $("select.tags-predefinis").on("change",function(e){
                var optionText = $(this).children("option:selected").text();
                //var optionValue = $(this).children("option:selected").text();
                if ($('#tags').find("option[value='" + optionText + "']").length) {
                    aux=$('#tags').val();
                    aux.push(optionText);
                    $('#tags').val(aux).trigger('change');
                } else {
                    // Create a DOM Option and pre-select by default
                    var newOption = new Option(optionText, optionText, true, true);
                    // Append it to the select
                    //$('#tags').append('<option>NewOption</option>').trigger('change');
                    $('#tags').append(newOption).trigger('change');
                    //$("#tagss option:selected").attr('disabled','disabled');

                }



                //$('#tags').append(`<option value="${optionText}"> ${optionValue} </option>`);
            });
        });





    </script>
@endsection
