@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route('galleryList') }}">Liste des Galleries Photos</a>
</li>
<li class="breadcrumb-item active">
    Nouvelle Gallerie Photos
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajxNewGallery') }}" method="post" id="createForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Nouvelle Gallerie
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="text" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title_flash">Titre flash </label>
                                    <input class="form-control" type="text" name="title_flash" id="title_flash" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_title">Titre SEO *</label>
                                    <input class="form-control" type="text" name="meta_title" id="meta_title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="display_user_id">Auteur affiché *</label>
                                    <select class="form-control" id='display_user_id' name='display_user_id'>
                                        <option value='{{Auth::user()->id}}'>{{Auth::user()->name}}</option>
                                        @foreach($users as $user)
                                            @if($user->id==23 )
                                            <option value="{{$user->id}}" selected="selected">{{$user->name}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="category">Catégories</label>
                                    <select class="form-control" id='category' name='category[]' multiple="multiple">
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}">{{ $category->title }}</option>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>


                            <div class="col-md-5">
                                    <div class="form-group">
                                        <label class="form-col-form-label" for="tags">Tags</label>
                                        <select class="form-control" id='tags' name='tags[]' multiple="multiple">
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="tagss">Tags Predefinis</label>
                                    <select class="form-control tags-predefinis" id='tagss' name='tagss[]'>
                                        @foreach($tagsPredefinis as $tags)
                                            <option value="{{ $tags->id }}" >{{ $tags->name }}</option>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="summary">Résumé *</label>
                                    <textarea class="form-control" id="summary" name="summary"></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_description">Déscription SEO *</label>
                                    <textarea class="form-control" id="meta_description" name="meta_description"></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_keywords">Mots Clés *</label>
                                    <input class="form-control" type="text" name="meta_keywords" id="meta_keywords" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_news_keywords">Mots Clés News *</label>
                                    <input class="form-control" type="text" name="meta_news_keywords" id="meta_news_keywords" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">

                                <div class="form-group">
                                    <input type="hidden" class="form-control" name="img" id="img" />
                                    <label class="form-col-form-label" for="img_maker">Image de couverture *</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control imgSelector" data-photoMaker="{{ route('PhotoArticle') }}" data-original="" disabled name="img_maker" data-dest="img" id="img_maker" />
                                        <span class="input-group-append">
                                            <button class="btn btn-primary popup_selector" data-inputid="img_maker" type="button">
                                                <i class="fa fa-photo"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-warning popup_selector_colse" data-inputid="img_maker" type="button">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-success popup_selector_visualize" href="" data-inputid="img_maker" type="button" disabled>
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </span>
                                    </div>

                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_alt">Alt image de couverture *</label>
                                    <input class="form-control" type="text" name="img_alt" id="img_alt" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            @for($i=1;$i<=10;$i++)
                                <div class="col-md-6">
                                    <input type="hidden" name="img{{$i}}" id="img{{$i}}" />
                                    <div class="form-group">
                                        <label class="form-col-form-label" for="img_maker{{$i}}">Image {{$i}}</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control imgSelector" data-photoMaker="{{ route('PhotoArticle') }}" data-original="" disabled name="img_maker{{$i}}" data-dest="img{{$i}}" id="img_maker{{$i}}" />
                                            <span class="input-group-append">
                                                <button class="btn btn-primary popup_selector" data-inputid="img_maker{{$i}}" type="button">
                                                    <i class="fa fa-photo"></i>
                                                </button>
                                            </span>
                                            <span class="input-group-append">
                                                <button class="btn btn-warning popup_selector_colse" data-inputid="img_maker{{$i}}" type="button">
                                                    <i class="fa fa-close"></i>
                                                </button>
                                            </span>
                                            <span class="input-group-append">
                                                <button class="btn btn-success popup_selector_visualize" href="" data-inputid="img_maker{{$i}}" type="button" disabled>
                                                    <i class="fa fa-eye"></i>
                                                </button>
                                            </span>
                                        </div>

                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                            @endfor


                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" id="last_news" name="last_news" type="checkbox" value="1">
                                        <label class="form-check-label" for="last_news">Dernières news</label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" id="flash_news" name="flash_news" type="checkbox" value="1">
                                        <label class="form-check-label" for="flash_news">Flash news</label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" id="facebook_instant_article" name="facebook_instant_article" type="checkbox" value="1">
                                        <label class="form-check-label" for="facebook_instant_article">Facebook instant article</label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" id="google_amp" name="google_amp" type="checkbox" value="1">
                                        <label class="form-check-label" for="google_amp">Google AMP</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" id="private_post" name="private_post" type="checkbox" value="1">
                                        <label class="form-check-label" for="private_post">Contenu privé</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="content">Contenu *</label>
                                    <textarea class="form-control" id="content" name="content"></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="status">Status</label>
                                    <select class="form-control" id='status' name='status'>
                                        <option value='0' selected="selected">Brouillon</option>
                                        <option value='1'>En attente de publication</option>
                                        @if(Auth::user()->hasRole("Admin") || Auth::user()->hasRole("Webmaster") || Auth::user()->hasRole("JournalisteWeb"))
                                            <option value='2'>Publié</option>
                                        @endif
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script>
        var elfinderUrl='{{ url("/elfinder/popup") }}/';
        var storagePath='{{ config("paths.STORAGE_PATH") }}';
        var photosUrl='{{ config("paths.PHOTOS_URL") }}';
    </script>
    <link rel="stylesheet" type="text/css" href="{{ asset( 'vendor/colorbox/css/colorbox.css') }}">
    <script src="{{ asset('vendor/colorbox/js/jquery.colorbox-min.js') }}"></script>
    <script src="{{ asset('packages/barryvdh/elfinder/js/standalonepopup.js') }}"></script>

    <script src="{{ asset('js/scripts/posts/create-gallery.js') }}"></script>
    <script>
 $(document).ready(function() {
            $('#category').select2();
            $('#tags').select2({
                tags: "true",
                ajax:{
                    url:"{{ route('tagsAjaxList') }}",
                    type:'get',
                    delay: 250,
                    data: function (params) {
                        var query = {
                            term: params.term
                        }
                        return query;
                    },
                    processResults: function (response){
                        return {
                            results:response
                        }
                    }
                },
                minimumInputLength:2
            });
        });
        CKEDITOR.replace( 'content',CKoptions );
        for (var i in CKEDITOR.instances) {
            CKEDITOR.instances[i].on('change', function() { CKEDITOR.instances[i].updateElement() });
        }
    </script>


    <script>
        $(document).ready(function(){
            $("select.tags-predefinis").on("change",function(e){
                var optionText = $(this).children("option:selected").text();
                //var optionValue = $(this).children("option:selected").text();
                if ($('#tags').find("option[value='" + optionText + "']").length) {
                    aux=$('#tags').val();
                    aux.push(optionText);
                    $('#tags').val(aux).trigger('change');
                } else {
                    // Create a DOM Option and pre-select by default
                    var newOption = new Option(optionText, optionText, true, true);
                    // Append it to the select
                    //$('#tags').append('<option>NewOption</option>').trigger('change');
                    $('#tags').append(newOption).trigger('change');
                    //$("#tagss option:selected").attr('disabled','disabled');

                }



                //$('#tags').append(`<option value="${optionText}"> ${optionValue} </option>`);
            });
        });




    </script>
@endsection
