@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">
    Liste des podcasts
</li>

@section("pageTopMenu")
    <a class="btn" href="{{ route('createPodcast') }}">+ Ajouter Podcast</a>
@endsection

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des Podcasts
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Titre</td>
                                <td>Emision/Rubrique</td>
                                <td>Animateur</td>
                                <td>Status</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($podcasts as $podcast)
                                <tr>
                                    <td>{{ $podcast->id }}</td>
                                    <td>{{ $podcast->title }}</td>
                                    <td>{{ $podcast->program->title }} / {{ $podcast->programSeance->title }}</td>
                                    <td>
                                        @foreach($podcast->animators as $animator)
                                            <span class="badge badge-primary">{{ $animator->name }}</span>
                                        @endforeach
                                    </td>
                                    <td>
                                        @if($podcast->status==0)
                                            Brouillon
                                        @else
                                            Publié
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('editPodcast',['podcastId'=>$podcast->id]) }}" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="{{ route('deletePodcast',['podcastId'=>$podcast->id]) }}" class="btn btn-sm btn-warning deletePodCast">Supprimer</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>

                    {{ $podcasts->onEachSide(5)->links() }}
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/podcast/delete.js') }}"></script>
@endsection
