@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
        <a href="{{ route('listPodcasts') }}">Liste des podcasts</a>
    </li>
<li class="breadcrumb-item active">
    Editer Podcast ({{$podcast->title}})
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajxUpdatePodcast',['podcastId'=>$podcast->id]) }}" method="post" id="editForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer podcast
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="title" value="{{$podcast->title}}" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_title">Titre SEO *</label>
                                    <input class="form-control" type="text" value="{{$podcast->meta_title}}" name="meta_title" id="meta_title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_description">Déscription SEO *</label>
                                    <textarea class="form-control" id="meta_description" name="meta_description">{{$podcast->meta_description}}</textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="animator">Animateurs *</label>
                                    <select class="form-control" id='animator' name='animator[]' multiple="multiple">
                                        @foreach($animators as $animator)
                                            <option value="{{ $animator->id }}" @if($podcast->animators->find($animator->id)) selected="selected" @endif >{{ $animator->name }}</option>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="seance">Emission *</label>
                                    <select class="form-control" id='seance' name='seance' >
                                        <option value=""></option>
                                        @foreach($programs as $program)
                                            <optgroup label="{{$program->title}}">
                                                @foreach($program->programSeances as $seance)
                                                    <option value="{{ $seance->id }}" @if($podcast->programSeance->id==$seance->id) selected="selected" @endif>{{ $seance->title }}</option>
                                                @endforeach
                                            </optgroup>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_keywords">Mots Clés *</label>
                                    <input class="form-control" type="text" value="{{$podcast->meta_keywords}}" name="meta_keywords" id="meta_keywords" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="live_date">Date live *</label>
                                    <input class="form-control" type="text" value="{{Carbon\Carbon::CreateFromFormat('Y-m-d H:i:s',$podcast->live_date)->format('d/m/Y H:i:s')}}" name="live_date" id="live_date" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                
                                <div class="form-group">
                                    <label class="form-col-form-label" for="mp3_file_input">Fichier MP3 *</label>
                                    <div class="input-group">
                                        <input type="hidden" value="{{$podcast->mp3}}" name="mp3_file" id="mp3_file" />
                                        <input type="text" class="form-control imgSelector" value="{{$podcast->mp3}}" data-original="mp3_file" disabled name="mp3_file_input" id="mp3_file_input" />
                                        <span class="input-group-append">
                                            <button class="btn btn-primary popup_selector" data-inputid="mp3_file_input" type="button">
                                                <i class="fa fa-play"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-warning popup_selector_colse" data-inputid="mp3_file_input" type="button">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </span>
                                    </div>
                                    
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="status">Status</label>
                                    <select class="form-control" id='status' name='status'>
                                        <option value='0' @if($podcast->status==0) selected="selected" @endif >Brouillon</option>
                                        <option value='1' @if($podcast->status==1) selected="selected" @endif >Publié</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script>
        var elfinderUrl='{{ url("/elfinder/popup") }}/';
        var storagePath='{{ config("paths.STORAGE_PATH") }}';
        var photosUrl='{{ config("paths.PHOTOS_URL") }}';
    </script>
    <link rel="stylesheet" type="text/css" href="{{ asset( 'vendor/colorbox/css/colorbox.css') }}">
    <script src="{{ asset('vendor/colorbox/js/jquery.colorbox-min.js') }}"></script>
    <script src="{{ asset('packages/barryvdh/elfinder/js/standalonepopup.js') }}"></script>
    
    <script src="{{ asset('js/scripts/podcast/edit-podcast.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#animator').select2();

            $("#live_date").datetimepicker({
                format:"DD/MM/YYYY HH:mm:ss"
            });
        });
        
    </script>
@endsection
