@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">Pages</li>
@endsection()

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des pages
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Titre</td>
                                <td>Description</td>
                                <td>Mot clés</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($pages as $page)
                                <tr>
                                    <td>{{ $page->id }}</td>
                                    <td>{{ $page->title }}</td>
                                    <td>{{ $page->description }}</td>
                                    <td>{{ $page->keywords }}</td>
                                    <td>
                                        <a href="{{ route('editPage',['pageId'=>$page->id]) }}" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="{{ route('deletePage',['PageId'=>$page->id]) }}" class="btn btn-sm btn-warning deletePage">Supprimer</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/pages/delete.js') }}"></script>
@endsection
