@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route("pagesList") }}">Pages</a>
</li>
<li class="breadcrumb-item active">
    Nouvelle Page
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajxNewPage') }}" method="post" id="createForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Nouvelle page
                    </div>

                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="title" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="url_title">Titre SEO *</label>
                                    <input class="form-control" type="text" name="url_title" id="url_title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="alias">Alias</label>
                                    <input class="form-control" type="text" name="alias" id="alias" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="keywords">Mots Clés *</label>
                                    <input class="form-control" type="text" name="keywords" id="keywords" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="description">Déscription *</label>
                                    <textarea class="form-control" id="description" name="description"></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="content">Contenu</label>
                                    <textarea class="form-control" id="content" name="content"></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('js/scripts/pages/create.js') }}"></script>
    <script>
        CKEDITOR.replace( 'content',CKoptions );
        for (var i in CKEDITOR.instances) {
            CKEDITOR.instances[i].on('change', function() { CKEDITOR.instances[i].updateElement() });
        }
    </script>
@endsection
